/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.element.item;

import cool.muyucloud.croparia.access.ElementAccess;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import cool.muyucloud.croparia.util.ItemPlaceable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ElementalPotion
extends Item
implements ElementAccess {
    private static final Map<ElementsEnum, ElementalPotion> POTIONS = new HashMap<ElementsEnum, ElementalPotion>();
    private final ElementsEnum element;

    public ElementalPotion(@NotNull ElementsEnum element, @NotNull Item.Properties properties) {
        super(properties);
        if (element == ElementsEnum.EMPTY) {
            throw new IllegalArgumentException("ElementalPotion cannot be empty element");
        }
        this.element = element;
        POTIONS.put(element, this);
        DispenserBlock.m_52672_((ItemLike)this, (blockSource, itemStack) -> {
            BlockState sourceState;
            Direction direction;
            BlockPos sourcePos;
            BlockPos targetPos;
            ServerLevel world = blockSource.m_7727_();
            BlockState targetState = world.m_8055_(targetPos = (sourcePos = blockSource.m_7961_()).m_141952_((direction = (Direction)(sourceState = blockSource.m_6414_()).m_61143_((Property)DispenserBlock.f_52659_)).m_122436_()));
            Block targetBlock = targetState.m_60734_();
            if (targetBlock instanceof Infusor) {
                Infusor infusor = (Infusor)targetBlock;
                if (!infusor.tryInfuse((Level)world, targetPos, this, itemStack, null)) {
                    infusor.placeItem((Level)world, targetPos, itemStack.m_41620_(1));
                }
            } else if (targetBlock instanceof ItemPlaceable) {
                ItemPlaceable placeable = (ItemPlaceable)targetBlock;
                placeable.placeItem((Level)world, targetPos, itemStack.m_41620_(1));
            }
            return itemStack;
        });
    }

    @Override
    @NotNull
    public ElementsEnum getElement() {
        return this.element;
    }

    public static Optional<ElementalPotion> fromElement(ElementsEnum element) {
        return Optional.ofNullable(POTIONS.get((Object)element));
    }
}

