/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator;

import com.google.gson.JsonObject;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.generator.pack.DataPackHandler;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.util.TagUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class BlockTagGenerator {
    private static final Map<ResourceLocation, JsonObject> TAGS = new HashMap<ResourceLocation, JsonObject>();

    public static void init() {
        Crops.forEachCrop(crop -> {
            BlockTagGenerator.addCropBlock(crop);
            BlockTagGenerator.addBeeGrowable(crop);
        });
        TAGS.forEach(DataPackHandler.INSTANCE::addBlockTag);
    }

    private static void addCropBlock(Crop crop) {
        JsonObject tag = BlockTagGenerator.getTag(ResourceLocation.m_135820_((String)"minecraft:crops"));
        TagUtil.addValue(tag, crop.getBlockId().toString());
    }

    private static void addBeeGrowable(Crop crop) {
        JsonObject tag = BlockTagGenerator.getTag(ResourceLocation.m_135820_((String)"minecraft:bee_growables"));
        TagUtil.addValue(tag, crop.getBlockId().toString());
    }

    protected static JsonObject getTag(ResourceLocation id) {
        JsonObject tag = TAGS.get(id);
        if (tag == null) {
            tag = TagUtil.create();
        }
        TAGS.put(id, tag);
        return tag;
    }
}

