/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.generator.PlaceHolder;
import cool.muyucloud.croparia.registry.Crops;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DataGenerator(boolean enabled, @NotNull String path, @Nullable String dependency, @NotNull Collection<String> crops, @NotNull String template) {
    public void generate(@NotNull Path root) {
        if (!this.enabled() || !Platform.isModLoaded((String)this.dependency)) {
            return;
        }
        if (this.crops.isEmpty()) {
            Crops.forEachCrop(crop -> this.generate((Crop)crop, root));
        } else {
            this.crops.forEach(name -> {
                Crop crop = Crops.forName(name);
                if (crop != null) {
                    this.generate(crop, root);
                } else {
                    CropariaIf.LOGGER.error("Crop \"{}\" not found for generator with path \"{}\"", name, (Object)this.path());
                }
            });
        }
    }

    private void generate(@NotNull Crop crop, @NotNull Path root) {
        Path path = root.resolve(this.replace(this.path(), crop));
        File parent = path.getParent().toFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            CropariaIf.LOGGER.error("Failed to establish data pack directory, path: \"%s\"".formatted(parent.getAbsolutePath()));
        }
        String replaced = this.replace(this.template(), crop);
        try (FileWriter writer = new FileWriter(path.toFile());){
            writer.write(replaced);
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to generate data for crop \"%s\", template path: \"%s\"".formatted(crop.getName(), this.path()), e);
        }
    }

    @NotNull
    public static Optional<DataGenerator> read(@NotNull Path file) {
        try {
            return Optional.of(DataGenerator.read(Files.readString(file)));
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Invalid data generator file \"%s\"".formatted(file), e);
            return Optional.empty();
        }
    }

    @NotNull
    public static DataGenerator read(@NotNull String content) throws RuntimeException {
        String[] lines = content.split("\n");
        StringBuilder builder = new StringBuilder();
        Map<String, String> meta = DataGenerator.readMeta(content);
        boolean enabled = Boolean.parseBoolean(meta.getOrDefault("enabled", "true"));
        String path = meta.getOrDefault("path", "");
        String dependency = meta.getOrDefault("dependency", "minecraft");
        List<String> crops = Arrays.stream(meta.getOrDefault("crops", "").split(",")).filter(crop -> !crop.isEmpty()).map(String::trim).toList();
        for (int i = meta.size(); i < lines.length; ++i) {
            String line = lines[i].replace("\r", "");
            builder.append(line).append("\n");
        }
        if (builder.isEmpty()) {
            throw new RuntimeException("Template is empty");
        }
        String template = builder.toString().trim();
        return new DataGenerator(enabled, path, dependency, crops, template);
    }

    public static Map<String, String> readMeta(String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : content.split("\n")) {
            if (!(line = line.trim()).startsWith("@")) break;
            String[] split = line.split("=");
            if (split.length != 2) continue;
            map.put(split[0].substring(1), split[1].replace("\r", "").replace("\n", ""));
        }
        return map;
    }

    @Override
    @NotNull
    public String toString() {
        return "@enabled=" + this.enabled() + "\n@path=" + this.path() + "\n" + this.template();
    }

    @NotNull
    public String replace(@NotNull String template, @NotNull Crop crop) {
        for (Map.Entry<Pattern, PlaceHolder> entry : crop.placeholders().entrySet()) {
            Pattern pattern = entry.getKey();
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String matched = matcher.group();
                template = template.replace(matched, entry.getValue().process(matched));
            }
        }
        return template;
    }

    @Override
    public int hashCode() {
        return this.path().hashCode();
    }
}

