/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator;

import com.google.gson.JsonObject;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.generator.pack.DataPackHandler;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.util.TagUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ItemTagGenerator {
    private static final Map<ResourceLocation, JsonObject> TAGS = new HashMap<ResourceLocation, JsonObject>();

    public static void init() {
        Crops.forEachCrop(crop -> {
            ItemTagGenerator.addFruit(crop);
            ItemTagGenerator.addSeed(crop);
        });
        TAGS.forEach(DataPackHandler.INSTANCE::addItemTag);
    }

    protected static void addFruit(Crop crop) {
        JsonObject tag = ItemTagGenerator.getTag(TagUtil.compatId("fruits"));
        TagUtil.addValue(tag, crop.getFruitId().toString());
    }

    protected static void addSeed(Crop crop) {
        JsonObject tag = ItemTagGenerator.getTag(CropariaIf.of("crop_seeds"));
        TagUtil.addValue(tag, crop.getSeedId().toString());
    }

    protected static JsonObject getTag(ResourceLocation id) {
        JsonObject tag = TAGS.get(id);
        if (tag == null) {
            tag = TagUtil.create();
        }
        TAGS.put(id, tag);
        return tag;
    }
}

