/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.generator.DataGenerator;
import cool.muyucloud.croparia.api.generator.pack.AlwaysEnabledFileResourcePackProvider;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import cool.muyucloud.croparia.kubejs.DataGeneratorCreator;
import cool.muyucloud.croparia.util.Util;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.NotNull;

public class DataPackHandler
extends PackHandler {
    public static final DataPackHandler INSTANCE = new DataPackHandler();
    private final AlwaysEnabledFileResourcePackProvider datapack = new AlwaysEnabledFileResourcePackProvider(CropariaIf.CONFIG.getPackPath(), PackSource.f_10528_);
    private final List<DataGenerator> generators = new LinkedList<DataGenerator>();

    @Override
    public void beforeReload() {
        super.beforeReload();
        this.moveBuiltInGenerators();
        this.readGenerators();
        this.dump();
    }

    @Override
    protected void generate() {
        super.generate();
        for (DataGenerator generator : this.generators) {
            generator.generate(CropariaIf.CONFIG.getPackPath().resolve("data"));
        }
    }

    public AlwaysEnabledFileResourcePackProvider getDatapack() {
        return this.datapack;
    }

    public void addItemTag(ResourceLocation location, JsonObject tag) {
        String path = "data/%s/tags/items/%s.json".formatted(location.m_135827_(), location.m_135815_());
        this.addFile(path, (JsonElement)tag);
    }

    public void addBlockTag(ResourceLocation location, JsonObject tag) {
        String path = "data/%s/tags/blocks/%s.json".formatted(location.m_135827_(), location.m_135815_());
        this.addFile(path, (JsonElement)tag);
    }

    @Override
    public void clear() {
        Path path = CropariaIf.CONFIG.getPackPath().resolve("data");
        File file = path.toFile();
        if (file.isDirectory()) {
            CropariaIf.LOGGER.info("Clearing data pack directory");
            try {
                Util.deleteDir(file);
            }
            catch (Throwable e) {
                CropariaIf.LOGGER.error("Failed to clear data pack directory", e);
            }
        }
    }

    public void moveBuiltInGenerators() {
        try {
            Path targetDir = CropariaIf.CONFIG.getPackPath().resolve("generators");
            File targetDirFile = targetDir.toFile();
            if (!targetDirFile.isDirectory() && !targetDirFile.mkdirs()) {
                throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(targetDir));
            }
            Enumeration<URL> urls = CropariaIf.class.getClassLoader().getResources("croparia-if-generators");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String jarPath = DataPackHandler.unifyUrl(url);
                try (JarFile jar = new JarFile(jarPath);){
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String filename;
                        File targetFile;
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith("croparia-if-generators/") || entry.isDirectory() || (targetFile = targetDir.resolve(filename = entry.getName().substring("croparia-if-generators/".length())).toFile()).isFile() && !Platform.isDevelopmentEnvironment()) continue;
                        try (FileOutputStream stream = new FileOutputStream(targetFile);){
                            jar.getInputStream(entry).transferTo(stream);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to move built-in generators", e);
        }
    }

    @NotNull
    private static String unifyUrl(URL url) {
        String urlPath;
        try {
            urlPath = URLDecoder.decode(url.getPath(), Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode URL", e);
        }
        Object jarPath = urlPath.substring(urlPath.indexOf("/") + 1, urlPath.lastIndexOf(".jar") + 4);
        if (!Path.of((String)jarPath, new String[0]).isAbsolute()) {
            jarPath = "/" + (String)jarPath;
        }
        return jarPath;
    }

    private void addGenerator(DataGenerator generator) {
        this.generators.add(generator);
    }

    public void readGenerators() {
        try {
            this.generators.clear();
            File root = CropariaIf.CONFIG.getPackPath().resolve("generators").toFile();
            if (!root.isDirectory() && !root.mkdirs()) {
                throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(root));
            }
            for (File file : Objects.requireNonNull(root.listFiles())) {
                if (!file.isFile()) continue;
                DataGenerator.read(file.toPath()).ifPresent(this::addGenerator);
            }
            DataGeneratorCreator.flushInto(this::addGenerator);
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to read generators", e);
        }
    }
}

