/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator.pack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.PackType;
import cool.muyucloud.croparia.CropariaIf;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;

public abstract class PackHandler {
    public static final Gson GSON = new Gson();
    public static final JsonObject META = new JsonObject();
    protected final Map<Path, JsonElement> cache = new HashMap<Path, JsonElement>();
    protected final Set<Runnable> GENERATORS = new HashSet<Runnable>();

    public void beforeReload() {
        if (CropariaIf.CONFIG.getOverride().booleanValue()) {
            this.clear();
        }
    }

    public abstract void clear();

    protected void writeJson(JsonElement element, File file) throws IOException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Failed to create directory " + String.valueOf(file.getParentFile()));
        }
        if (!file.exists() || file.exists() && CropariaIf.CONFIG.getOverride().booleanValue()) {
            FileWriter writer = new FileWriter(file);
            GSON.toJson(element, (Appendable)writer);
            writer.close();
        }
    }

    public void dump() {
        try {
            this.generate();
            for (Map.Entry<Path, JsonElement> entry : this.cache.entrySet()) {
                this.writeJson(entry.getValue(), entry.getKey().toFile());
            }
        }
        catch (Exception e) {
            CropariaIf.LOGGER.error("Failed to write pack data to file system", (Throwable)e);
        }
        this.cache.clear();
    }

    public void addFile(String relative, JsonElement element) {
        Path path = CropariaIf.CONFIG.getPackPath().resolve(relative);
        this.cache.put(path, element);
    }

    protected void generate() {
        this.cache.clear();
        for (Runnable generator : this.GENERATORS) {
            generator.run();
        }
    }

    public void registerGenerator(Runnable generator) {
        this.GENERATORS.add(generator);
    }

    static {
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)SharedConstants.m_183709_().getPackVersion(PackType.DATA));
        pack.addProperty("description", "Croparia mandatory pack in %s.\nPlease do not modify data / assets folders!".formatted(CropariaIf.CONFIG.getPackPath()));
        META.add("pack", (JsonElement)pack);
    }
}

