/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.math;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.ListCodec;
import cool.muyucloud.croparia.api.math.Vec2i;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class Char2D
implements Iterable<Character> {
    public static final Codec<Char2D> CODEC = new ListCodec((Codec)Codec.STRING).xmap(Char2D::new, Char2D::surface);
    private final char[][] chars;

    public Char2D(List<String> surface) {
        if (surface.isEmpty()) {
            throw new IllegalArgumentException("Empty surface");
        }
        int cols = surface.get(0).length();
        int rows = surface.size();
        this.chars = new char[rows][cols];
        for (int z = 0; z < rows; ++z) {
            String row = surface.get(z);
            if (row.length() != cols) {
                throw new IllegalArgumentException("Varying length: " + String.valueOf(surface));
            }
            this.chars[z] = row.toCharArray();
        }
    }

    public Char2D(int maxX, int maxZ) {
        this.chars = new char[maxZ][maxX];
    }

    public List<String> surface() {
        return Arrays.stream(this.chars).map(String::new).toList();
    }

    public int maxZ() {
        return this.chars.length;
    }

    public int maxX() {
        return this.chars.length == 0 ? 0 : this.chars[0].length;
    }

    public Char2D rotate() {
        Char2D rotated = new Char2D(this.maxX(), this.maxZ());
        for (int z = 0; z < this.maxZ(); ++z) {
            for (int x = 0; x < this.maxX(); ++x) {
                rotated.chars[x][this.maxZ() - z - 1] = this.chars[z][x];
            }
        }
        return rotated;
    }

    public Char2D mirror() {
        Char2D mirrored = new Char2D(this.maxZ(), this.maxX());
        for (int z = 0; z < this.maxZ(); ++z) {
            for (int x = 0; x < this.maxX(); ++x) {
                mirrored.chars[z][this.maxX() - x - 1] = this.chars[z][x];
            }
        }
        return mirrored;
    }

    public char get(int x, int z) {
        return this.chars[z][x];
    }

    public boolean contains(char c) {
        for (char character : this) {
            if (character != c) continue;
            return true;
        }
        return false;
    }

    public int count(char c) {
        int count = 0;
        for (char character : this) {
            if (character != c) continue;
            ++count;
        }
        return count;
    }

    public Optional<Vec2i> find(char c) {
        for (int z = 0; z < this.maxZ(); ++z) {
            for (int x = 0; x < this.maxX(); ++x) {
                if (this.get(x, z) != c) continue;
                return Optional.of(Vec2i.of(x, z));
            }
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Iterator<Character> iterator() {
        return new Char2DIterator(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (char[] row : this.chars) {
            builder.append(String.valueOf(row)).append(",\n");
        }
        return builder.substring(0, builder.length() - 2) + "]";
    }

    public static class Char2DIterator
    implements Iterator<Character> {
        private final Char2D char2D;
        private int z = 0;
        private int x = 0;

        public Char2DIterator(Char2D surface) {
            this.char2D = surface;
        }

        @Override
        public boolean hasNext() {
            return this.z >= this.char2D.maxZ();
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                return null;
            }
            char result = this.char2D.get(this.z, this.x);
            ++this.x;
            if (this.x == this.char2D.maxX()) {
                this.x = 0;
                ++this.z;
            }
            return Character.valueOf(result);
        }
    }
}

