/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.math;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.api.math.Char2D;
import cool.muyucloud.croparia.api.math.Vec2i;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

public class Char3D
implements Iterable<Character> {
    public static final Codec<Char3D> CODEC = new ListCodec(Char2D.CODEC).xmap(Char3D::new, Char3D::structure);
    public static final MapCodec<Char3D> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("value").forGetter(char3d -> char3d)).apply((Applicative)instance, value -> value));
    private final List<Char2D> pattern;

    public Char3D(List<Char2D> structure) {
        int height = structure.size();
        int maxZ = structure.get(0).maxZ();
        int maxX = structure.get(0).maxX();
        this.pattern = new ArrayList<Char2D>(height);
        for (Char2D surface : structure) {
            if (surface.maxZ() != maxZ || surface.maxX() != maxX) {
                throw new IllegalArgumentException("Varying size: " + String.valueOf(structure));
            }
            this.pattern.add(surface);
        }
    }

    public List<Char2D> structure() {
        return ImmutableList.copyOf(this.pattern);
    }

    public Vec3i size() {
        return new Vec3i(this.maxX(), this.maxY(), this.maxZ());
    }

    protected Char3D rotate() {
        ArrayList<Char2D> rotated = new ArrayList<Char2D>(this.pattern.size());
        for (Char2D surface : this.pattern) {
            rotated.add(surface.rotate());
        }
        return new Char3D(rotated);
    }

    protected Char3D mirror() {
        ArrayList<Char2D> mirrored = new ArrayList<Char2D>(this.pattern.size());
        for (Char2D surface : this.pattern) {
            mirrored.add(surface.mirror());
        }
        return new Char3D(mirrored);
    }

    public int maxY() {
        return this.pattern.size();
    }

    public int maxZ() {
        return this.pattern.isEmpty() ? 0 : this.pattern.get(0).maxZ();
    }

    public int maxX() {
        return this.pattern.isEmpty() ? 0 : this.pattern.get(0).maxX();
    }

    public char get(int x, int y, int z) {
        return this.pattern.get(y).get(x, z);
    }

    public int count(char c) {
        int count = 0;
        for (char ch : this) {
            if (ch != c) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public Optional<Vec3i> find(char c) {
        for (int y = 0; y < this.maxY(); ++y) {
            Optional<Vec2i> result = this.pattern.get(y).find(c);
            if (!result.isPresent()) continue;
            Vec2i pos = result.get();
            return Optional.of(pos.toVec3i(y));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Iterator<Character> iterator() {
        return new Char3DIterator(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (Char2D layer : this.pattern) {
            builder.append(layer).append(",\n");
        }
        return builder.substring(0, builder.length() - 2) + "]";
    }

    public static class Char3DIterator
    implements Iterator<Character> {
        private final Char3D char3D;
        private int x = 0;
        private int y = 0;
        private int z = 0;

        public Char3DIterator(Char3D structure) {
            this.char3D = structure;
        }

        @Override
        public boolean hasNext() {
            return this.z > this.char3D.maxY();
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                return null;
            }
            char result = this.char3D.get(this.x, this.y, this.z);
            ++this.x;
            if (this.x == this.char3D.maxX()) {
                this.x = 0;
                ++this.y;
                if (this.y == this.char3D.maxZ()) {
                    this.y = 0;
                    ++this.z;
                }
            }
            return Character.valueOf(result);
        }
    }
}

