/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.forge;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.forge.ForgeFluidSpec;
import cool.muyucloud.croparia.api.resource.type.FluidSpec;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidRepoProxy
extends RepoProxy<FluidSpec>
implements IFluidHandler {
    public FluidRepoProxy(Repo<FluidSpec> repo) {
        super(repo);
    }

    public int getTanks() {
        return this.get().size();
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        FluidSpec fluidSpec = (FluidSpec)this.resourceFor(i);
        return ForgeFluidSpec.of(fluidSpec, this.amountFor(i, fluidSpec));
    }

    public int getTankCapacity(int i) {
        return (int)(this.capacityFor(i, (FluidSpec)this.resourceFor(i)) / 81L);
    }

    public boolean isFluidValid(int i, @NotNull FluidStack input) {
        long amount;
        FluidSpec fluid = ForgeFluidSpec.from(input);
        return this.simAccept(i, fluid, amount = (long)input.getAmount() * 81L) >= amount;
    }

    public int fill(FluidStack input, IFluidHandler.FluidAction fluidAction) {
        FluidSpec fluid = ForgeFluidSpec.from(input);
        if (fluidAction.simulate()) {
            return (int)(this.simAccept(fluid, (long)input.getAmount() * 81L) / 81L);
        }
        if (fluidAction.execute()) {
            return (int)(this.accept(fluid, (long)input.getAmount() * 81L) / 81L);
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack input, IFluidHandler.FluidAction fluidAction) {
        FluidSpec fluid = ForgeFluidSpec.from(input);
        if (fluidAction.simulate()) {
            long consumed = this.simConsume(ForgeFluidSpec.from(input), (long)input.getAmount() * 81L);
            return ForgeFluidSpec.of(fluid, consumed);
        }
        if (fluidAction.execute()) {
            long consumed = this.consume(ForgeFluidSpec.from(input), (long)input.getAmount() * 81L);
            return ForgeFluidSpec.of(fluid, consumed);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
        if (this.size() < 1) {
            return FluidStack.EMPTY;
        }
        FluidSpec fluid = (FluidSpec)this.resourceFor(0);
        if (fluidAction.simulate()) {
            long consumed = this.simConsume(fluid, (long)amount * 81L);
            return ForgeFluidSpec.of(fluid, consumed);
        }
        if (fluidAction.execute()) {
            long consumed = this.consume(fluid, (long)amount * 81L);
            return ForgeFluidSpec.of(fluid, consumed);
        }
        return FluidStack.EMPTY;
    }
}

