/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.forge;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.platform.PlatformFluidProxy;
import cool.muyucloud.croparia.api.resource.forge.ForgeFluidSpec;
import cool.muyucloud.croparia.api.resource.type.FluidSpec;
import java.util.Optional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PlatformFluidProxyImpl
implements PlatformFluidProxy {
    private final IFluidHandler handler;

    public static PlatformFluidProxyImpl of(IFluidHandler handler) {
        return new PlatformFluidProxyImpl(handler);
    }

    public PlatformFluidProxyImpl(IFluidHandler handler) {
        this.handler = handler;
    }

    public IFluidHandler get() {
        return this.handler;
    }

    @Override
    public Optional<Repo<FluidSpec>> peel() {
        Optional<Repo<FluidSpec>> optional;
        IFluidHandler iFluidHandler = this.get();
        if (iFluidHandler instanceof Repo) {
            Repo repo = (Repo)iFluidHandler;
            optional = Optional.of(repo);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public int size() {
        return this.get().getTanks();
    }

    @Override
    public boolean isEmpty(int i) {
        return this.get().getFluidInTank(i).isEmpty();
    }

    @Override
    public long simConsume(FluidSpec fluid, long amount) {
        return (long)this.get().drain(ForgeFluidSpec.of(fluid, amount), IFluidHandler.FluidAction.SIMULATE).getAmount() * 81L;
    }

    @Override
    public long simConsume(int i, FluidSpec resource, long amount) {
        FluidStack stored = this.get().getFluidInTank(i);
        FluidStack wanted = ForgeFluidSpec.of(resource, Math.min((long)stored.getAmount(), amount));
        if (ForgeFluidSpec.matches(resource, stored)) {
            return (long)this.get().drain(wanted, IFluidHandler.FluidAction.SIMULATE).getAmount() * 81L;
        }
        return 0L;
    }

    @Override
    public long consume(FluidSpec resource, long amount) {
        return (long)this.get().drain(ForgeFluidSpec.of(resource, amount), IFluidHandler.FluidAction.EXECUTE).getAmount() * 81L;
    }

    @Override
    public long consume(int i, FluidSpec resource, long amount) {
        FluidStack wanted;
        FluidStack stored = this.get().getFluidInTank(i);
        if (stored.containsFluid(wanted = ForgeFluidSpec.of(resource, amount)) && stored.getAmount() >= wanted.getAmount()) {
            return this.consume(resource, Math.min(amount, (long)stored.getAmount() * 81L));
        }
        return 0L;
    }

    @Override
    public long simAccept(FluidSpec resource, long amount) {
        return (long)this.get().fill(ForgeFluidSpec.of(resource, amount), IFluidHandler.FluidAction.SIMULATE) * 81L;
    }

    @Override
    public long simAccept(int i, FluidSpec resource, long amount) {
        FluidStack stored = this.get().getFluidInTank(i);
        int capacity = this.get().getTankCapacity(i);
        FluidStack wanted = ForgeFluidSpec.of(resource, Math.min((long)(capacity - stored.getAmount()), amount / 81L));
        if (ForgeFluidSpec.matches(resource, stored) || stored.isEmpty()) {
            return (long)this.get().fill(wanted, IFluidHandler.FluidAction.SIMULATE) * 81L;
        }
        return 0L;
    }

    @Override
    public long accept(FluidSpec fluid, long amount) {
        return (long)this.get().fill(ForgeFluidSpec.of(fluid, amount), IFluidHandler.FluidAction.EXECUTE) * 81L;
    }

    @Override
    public long accept(int i, FluidSpec fluid, long amount) {
        FluidStack stored = this.get().getFluidInTank(i);
        int capacity = this.get().getTankCapacity(i);
        FluidStack wanted = ForgeFluidSpec.of(fluid, Math.min((long)(capacity - stored.getAmount()), amount / 81L));
        if (ForgeFluidSpec.matches(fluid, stored) || stored.isEmpty()) {
            return (long)this.get().fill(wanted, IFluidHandler.FluidAction.SIMULATE) * 81L;
        }
        return 0L;
    }

    @Override
    public long capacityFor(int i, FluidSpec fluid) {
        FluidStack stored = this.get().getFluidInTank(i);
        if (stored.isEmpty() && this.get().isFluidValid(i, ForgeFluidSpec.of(fluid, 1))) {
            return (long)this.get().getTankCapacity(i) * 81L;
        }
        return ForgeFluidSpec.matches(fluid, stored) ? (long)this.get().getTankCapacity(i) * 81L : 0L;
    }

    @Override
    public long amountFor(int i, FluidSpec fluid) {
        FluidStack stack = this.get().getFluidInTank(i);
        return ForgeFluidSpec.matches(fluid, stack) ? (long)stack.getAmount() * 81L : 0L;
    }

    @Override
    public FluidSpec resourceFor(int i) {
        return ForgeFluidSpec.from(this.get().getFluidInTank(i));
    }
}

