/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.forge;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.platform.PlatformItemProxy;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class PlatformItemProxyImpl
implements PlatformItemProxy {
    private final IItemHandler handler;

    public static PlatformItemProxyImpl of(IItemHandler handler) {
        return new PlatformItemProxyImpl(handler);
    }

    public PlatformItemProxyImpl(IItemHandler handler) {
        this.handler = handler;
    }

    public IItemHandler get() {
        return this.handler;
    }

    @Override
    public Optional<Repo<ItemSpec>> peel() {
        Optional<Repo<ItemSpec>> optional;
        IItemHandler iItemHandler = this.get();
        if (iItemHandler instanceof Repo) {
            Repo repo = (Repo)iItemHandler;
            optional = Optional.of(repo);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public int size() {
        return this.get().getSlots();
    }

    @Override
    public boolean isEmpty(int i) {
        return this.get().getStackInSlot(i).m_41619_();
    }

    @Override
    public long simConsume(int i, ItemSpec item, long amount) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (item.matches(stored)) {
            return this.get().extractItem(i, (int)Math.min(amount, (long)stored.m_41613_()), true).m_41613_();
        }
        return 0L;
    }

    @Override
    public long consume(int i, ItemSpec item, long amount) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (item.matches(stored)) {
            return this.get().extractItem(i, (int)Math.min(amount, (long)stored.m_41613_()), false).m_41613_();
        }
        return 0L;
    }

    @Override
    public long simAccept(int i, ItemSpec item, long amount) {
        return this.get().insertItem(i, item.toStack(amount), true).m_41613_();
    }

    @Override
    public long accept(int i, ItemSpec item, long amount) {
        return this.get().insertItem(i, item.toStack(amount), false).m_41613_();
    }

    @Override
    public long capacityFor(int i, ItemSpec item) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (stored.m_41619_() && this.get().insertItem(i, item.toStack(1L), true).m_41613_() == 1 || item.matches(stored)) {
            return this.get().getSlotLimit(i);
        }
        return 0L;
    }

    @Override
    public long amountFor(int i, ItemSpec item) {
        ItemStack stored = this.get().getStackInSlot(i);
        if (item.matches(stored)) {
            return stored.m_41613_();
        }
        return 0L;
    }

    @Override
    public ItemSpec resourceFor(int i) {
        return ItemSpec.from(this.get().getStackInSlot(i));
    }
}

