/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.forge;

import cool.muyucloud.croparia.api.repo.ProxyProvider;
import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.repo.forge.PlatformFluidProxyImpl;
import cool.muyucloud.croparia.api.repo.forge.PlatformItemProxyImpl;
import cool.muyucloud.croparia.api.repo.platform.PlatformFluidProxy;
import cool.muyucloud.croparia.api.repo.platform.PlatformItemProxy;
import cool.muyucloud.croparia.api.resource.type.FluidSpec;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ProxyProviderImpl {
    private static Map<Block, List<ProxyProvider<ItemSpec>>> ITEMS = new HashMap<Block, List<ProxyProvider<ItemSpec>>>();
    private static Map<Block, List<ProxyProvider<FluidSpec>>> FLUIDS = new HashMap<Block, List<ProxyProvider<FluidSpec>>>();

    public static Optional<PlatformItemProxy> findItem(Level world, BlockPos pos, Direction direction) {
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return Optional.empty();
        }
        return be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).map(PlatformItemProxyImpl::of);
    }

    public static Optional<PlatformFluidProxy> findFluid(Level world, BlockPos pos, Direction direction) {
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return Optional.empty();
        }
        return be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).map(PlatformFluidProxyImpl::of);
    }

    public static void registerItem(ProxyProvider<ItemSpec> provider, Block ... blocks) {
        for (Block block : blocks) {
            if (!(block instanceof BaseEntityBlock)) {
                Repo.LOGGER.error("Registering item proxy on a non-entity block: {}, which will not work on forge", (Object)block);
            }
            ITEMS.computeIfAbsent(block, k -> new ArrayList()).add(provider);
        }
    }

    public static void registerFluid(ProxyProvider<FluidSpec> provider, Block ... blocks) {
        for (Block block : blocks) {
            if (!(block instanceof BaseEntityBlock)) {
                Repo.LOGGER.error("Registering fluid proxy on a non-entity block: {}, which will not work on forge", (Object)block);
            }
            FLUIDS.computeIfAbsent(block, k -> new ArrayList()).add(provider);
        }
    }

    public static void freeze() {
        HashMap items = new HashMap();
        HashMap fluids = new HashMap();
        ITEMS.forEach((block, providers) -> items.put(block, Collections.unmodifiableList(providers)));
        FLUIDS.forEach((block, providers) -> fluids.put(block, Collections.unmodifiableList(providers)));
        ITEMS = Collections.unmodifiableMap(items);
        FLUIDS = Collections.unmodifiableMap(fluids);
    }

    public static Optional<IItemHandler> findItem(Level world, BlockPos pos, BlockState state, BlockEntity be, Direction direction) {
        List<ProxyProvider<ItemSpec>> providers = ITEMS.get(state.m_60734_());
        if (providers == null) {
            return Optional.empty();
        }
        for (ProxyProvider<ItemSpec> provider : providers) {
            RepoProxy<ItemSpec> proxy = provider.visit(world, pos, state, be, direction);
            if (proxy == null) continue;
            return Optional.of((IItemHandler)proxy);
        }
        return Optional.empty();
    }

    public static Optional<IFluidHandler> findFluid(Level world, BlockPos pos, BlockState state, BlockEntity be, Direction direction) {
        List<ProxyProvider<FluidSpec>> providers = FLUIDS.get(state.m_60734_());
        if (providers == null) {
            return Optional.empty();
        }
        for (ProxyProvider<FluidSpec> provider : providers) {
            RepoProxy<FluidSpec> proxy = provider.visit(world, pos, state, be, direction);
            if (proxy == null) continue;
            return Optional.of((IFluidHandler)proxy);
        }
        return Optional.empty();
    }
}

