/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.resource.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.resource.ResourceType;
import cool.muyucloud.croparia.api.resource.TypeToken;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSpec
implements ResourceType {
    public static final MapCodec<FluidSpec> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(fluid -> fluid.getFluid().arch$registryName()), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(FluidSpec::getNbt)).apply((Applicative)instance, (id, nbt) -> new FluidSpec((Fluid)Registry.f_122822_.m_7745_(id), nbt.orElse(null))));
    public static final FluidSpec EMPTY = new FluidSpec(Fluids.f_76191_, null);
    public static final TypeToken<FluidSpec> TYPE = TypeToken.register(CropariaIf.of("fluid_spec"), EMPTY, CODEC).orElseThrow();
    private final Fluid fluid;
    @Nullable
    private final CompoundTag nbt;

    public static FluidSpec of(@NotNull Fluid fluid) {
        return new FluidSpec(fluid, null);
    }

    public static FluidSpec of(@NotNull Fluid fluid, @Nullable CompoundTag nbt) {
        return new FluidSpec(fluid, nbt);
    }

    public FluidSpec(@NotNull Fluid fluid, @Nullable CompoundTag nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Optional<CompoundTag> getNbt() {
        return Optional.ofNullable(this.nbt);
    }

    public FluidSpec withFluid(Fluid fluid) {
        return new FluidSpec(fluid, this.nbt);
    }

    public FluidSpec replaceNbt(@NotNull CompoundTag nbt) {
        return new FluidSpec(this.fluid, nbt);
    }

    @Override
    public boolean isEmpty() {
        return this.getFluid() == Fluids.f_76191_;
    }

    public TypeToken<FluidSpec> getType() {
        return TYPE;
    }

    public boolean is(@NotNull Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FluidSpec)) {
            return false;
        }
        FluidSpec fluidSpec = (FluidSpec)o;
        return Objects.equals(this.fluid, fluidSpec.fluid) && Objects.equals(this.nbt, fluidSpec.nbt);
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.nbt);
    }

    @Override
    public MapCodec<?> getCodec() {
        return CODEC;
    }
}

