/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.resource.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.resource.ResourceType;
import cool.muyucloud.croparia.api.resource.TypeToken;
import cool.muyucloud.croparia.util.TagUtil;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSpec
implements ResourceType {
    public static final MapCodec<ItemSpec> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(item -> item.getItem().arch$registryName()), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(ItemSpec::getNbt)).apply((Applicative)instance, (id, nbt) -> new ItemSpec((Item)Registry.f_122827_.m_7745_(id), nbt.orElse(null))));
    public static final ItemSpec EMPTY = new ItemSpec(Items.f_41852_, null);
    public static final TypeToken<ItemSpec> TYPE = TypeToken.register(CropariaIf.of("item_spec"), EMPTY, CODEC).orElseThrow();
    private final Item item;
    private final CompoundTag nbt;

    public static ItemSpec from(ItemStack stack) {
        return new ItemSpec(stack.m_41720_(), stack.m_41783_());
    }

    public static ItemSpec from(Item item) {
        return new ItemSpec(item, null);
    }

    public ItemSpec(@NotNull Item item, @Nullable CompoundTag nbt) {
        this.item = item;
        this.nbt = nbt;
    }

    public Item getItem() {
        return this.item;
    }

    public Optional<CompoundTag> getNbt() {
        return Optional.ofNullable(this.nbt);
    }

    public ItemSpec withItem(Item item) {
        return new ItemSpec(item, this.nbt);
    }

    public ItemSpec replaceNbt(@NotNull CompoundTag nbt) {
        return new ItemSpec(this.item, nbt);
    }

    @Override
    public boolean isEmpty() {
        return this.getItem() == Items.f_41852_;
    }

    public ItemStack toStack(long amount) {
        ItemStack stack = new ItemStack((ItemLike)this.getItem());
        stack.m_41751_((CompoundTag)this.getNbt().orElse(null));
        stack.m_41764_((int)Math.min(Integer.MAX_VALUE, amount));
        return stack;
    }

    public ItemStack toStack() {
        ItemStack stack = this.getItem().m_7968_();
        stack.m_41751_((CompoundTag)this.getNbt().orElse(null));
        return stack;
    }

    public boolean is(Item item) {
        return this.getItem() == item;
    }

    public boolean is(ItemStack stack) {
        return ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.toStack());
    }

    public boolean isOf(ResourceLocation tag) {
        return TagUtil.isIn(TagKey.m_203882_((ResourceKey)Registry.f_122827_.m_123023_(), (ResourceLocation)tag), this.getItem());
    }

    public boolean matches(ItemStack stack) {
        return ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.toStack());
    }

    public TypeToken<ItemSpec> getType() {
        return TYPE;
    }

    @Override
    public MapCodec<?> getCodec() {
        return CODEC;
    }
}

