/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.client.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.generator.pack.ResourcePackHandler;
import cool.muyucloud.croparia.registry.Crops;

public class ItemModelGenerator {
    public static void init() {
        Crops.forEachCrop(crop -> {
            ItemModelGenerator.addFruit(crop);
            ItemModelGenerator.addSeed(crop);
        });
    }

    public static void addFruit(Crop crop) {
        String type = crop.getType().getModelName();
        JsonObject fruit = new JsonObject();
        fruit.addProperty("parent", "minecraft:item/generated");
        JsonObject fruitTextures = new JsonObject();
        fruitTextures.addProperty("layer0", "croparia:item/fruit_%s".formatted(type));
        fruitTextures.addProperty("layer1", "croparia:item/fruit_%s_overlay".formatted(type));
        fruit.add("textures", (JsonElement)fruitTextures);
        ResourcePackHandler.INSTANCE.addItemModel(crop.getFruitId(), fruit);
    }

    public static void addSeed(Crop crop) {
        JsonObject seed = new JsonObject();
        seed.addProperty("parent", "minecraft:item/generated");
        JsonObject seedTextures = new JsonObject();
        seedTextures.addProperty("layer0", "croparia:item/seed_crop");
        seed.add("textures", (JsonElement)seedTextures);
        ResourcePackHandler.INSTANCE.addItemModel(crop.getSeedId(), seed);
    }
}

