/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.client.generator;

import com.google.gson.JsonObject;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.generator.pack.ResourcePackHandler;
import cool.muyucloud.croparia.registry.Crops;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class LangGenerator {
    public static final Map<ResourceLocation, Map<String, String>> CACHE = new HashMap<ResourceLocation, Map<String, String>>();

    public static void init() {
        Crops.forEachCrop(LangGenerator::addCrop);
        for (Map.Entry<ResourceLocation, Map<String, String>> entry : CACHE.entrySet()) {
            ResourceLocation lang = entry.getKey();
            Map<String, String> map = entry.getValue();
            JsonObject json = new JsonObject();
            map.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            ResourcePackHandler.INSTANCE.addLang(lang, json);
        }
    }

    public static void addCrop(Crop crop) {
        String key = crop.getTranslationKey();
        for (String lang : crop.availableLangs()) {
            ResourceLocation id = new ResourceLocation("croparia", lang);
            Map map = CACHE.getOrDefault(id, new HashMap());
            map.put(key, crop.translate(lang));
            CACHE.put(id, map);
        }
    }
}

