/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.display;

import cool.muyucloud.croparia.api.core.recipe.InfusorRecipe;
import cool.muyucloud.croparia.compat.rei.display.category.InfusorRecipeDisplayCategory;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class InfusorRecipeDisplay
implements Display {
    private final InfusorRecipe recipe;

    public InfusorRecipeDisplay(InfusorRecipe recipe) {
        this.recipe = recipe;
    }

    public Collection<EntryStack<ItemStack>> getIngredient() {
        return this.recipe.getIngredient().availableStacks().stream().map(stack -> {
            LinkedList<MutableComponent> tooltips = new LinkedList<MutableComponent>();
            tooltips.add(Constants.ITEM_DROP_TOOLTIP);
            this.recipe.getIngredient().nbtTooltip().ifPresent(tooltips::add);
            return EntryStacks.of((ItemStack)stack).tooltip(tooltips);
        }).toList();
    }

    public EntryStack<ItemStack> getElement() {
        ItemStack potion = this.recipe.getPotion().m_7968_();
        LinkedList<MutableComponent> tooltips = new LinkedList<MutableComponent>(potion.m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL));
        tooltips.set(0, Constants.ELEM_INFUSE_TOOLTIP);
        return EntryStacks.of((ItemLike)this.recipe.getPotion()).tooltip(tooltips);
    }

    public EntryStack<ItemStack> getResult() {
        return EntryStacks.of((ItemStack)this.recipe.getResult());
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(EntryIngredients.of((EntryType)VanillaEntryTypes.ITEM, this.recipe.getIngredient().availableStacks()), EntryIngredients.of((ItemLike)this.recipe.getPotion()), EntryIngredients.of((ItemLike)((ItemLike)CropariaItems.INFUSOR.get())));
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredients.of((ItemStack)this.recipe.getResult()));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return InfusorRecipeDisplayCategory.ID;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.recipe.m_6423_());
    }
}

