/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.display;

import cool.muyucloud.croparia.api.core.recipe.RitualRecipe;
import cool.muyucloud.croparia.compat.rei.display.category.RitualRecipeDisplayCategory;
import cool.muyucloud.croparia.util.Constants;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RitualRecipeDisplay
implements Display {
    private final RitualRecipe recipe;

    public RitualRecipeDisplay(RitualRecipe recipe) {
        this.recipe = recipe;
    }

    public Collection<EntryStack<ItemStack>> getIngredient() {
        return this.recipe.getIngredient().availableStacks().stream().map(stack -> {
            LinkedList<MutableComponent> tooltips = new LinkedList<MutableComponent>();
            tooltips.add(Constants.ITEM_DROP_TOOLTIP);
            this.recipe.getIngredient().nbtTooltip().ifPresent(tooltips::add);
            return EntryStacks.of((ItemStack)stack).tooltip(tooltips);
        }).toList();
    }

    public Collection<EntryStack<ItemStack>> getBlockItems() {
        return this.recipe.extractBlockItems().stream().map(item -> {
            LinkedList<Object> tooltips = new LinkedList<Object>();
            tooltips.add(Constants.BLOCK_PLACE_TOOLTIP);
            tooltips.addAll(this.recipe.getBlock().tooltip());
            return EntryStacks.of((ItemStack)item).tooltip(tooltips);
        }).toList();
    }

    public EntryStack<ItemStack> getResult() {
        return EntryStacks.of((ItemStack)this.recipe.getResult());
    }

    public EntryStack<ItemStack> getRitual() {
        return EntryStacks.of((ItemStack)this.recipe.getRitualItem()).tooltip(new Component[]{Constants.TOOLTIP_RITUAL});
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(EntryIngredients.of((EntryType)VanillaEntryTypes.ITEM, this.recipe.extractBlockItems()), EntryIngredients.of((EntryType)VanillaEntryTypes.ITEM, this.recipe.getIngredient().availableStacks()), EntryIngredients.of((ItemStack)this.recipe.getRitualItem()));
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredients.of((ItemStack)this.recipe.getResult()));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return RitualRecipeDisplayCategory.ID;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.recipe.m_6423_());
    }
}

