/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.display;

import cool.muyucloud.croparia.api.core.item.Placeholder;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.core.recipe.predicate.BlockStatePredicate;
import cool.muyucloud.croparia.compat.rei.display.category.RitualStructureDisplayCategory;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RitualStructureDisplay
implements Display {
    private static final EntryStack<ItemStack> AIR = EntryStacks.of((ItemStack)BlockStatePredicate.STACK_AIR);
    private static final EntryStack<ItemStack> ANY = EntryStacks.of((ItemStack)BlockStatePredicate.STACK_ANY);
    private static final EntryStack<ItemStack> UNKNOWN = EntryStacks.of((ItemStack)BlockStatePredicate.STACK_UNKNOWN);
    private static final EntryStack<ItemStack> INPUT = EntryStacks.of((ItemStack)((Placeholder)((Object)CropariaItems.PLACEHOLDER.get())).m_7968_().m_41714_((Component)Constants.TOOLTIP_INPUT));
    private final List<EntryIngredient> input;
    private final Collection<EntryStack<ItemStack>>[][][] structure;
    private final EntryStack<ItemStack> ritual;
    private final ResourceLocation id;
    private int lastRead = 0;

    public RitualStructureDisplay(RitualStructure structure) {
        this.structure = new Collection[structure.maxY()][structure.maxZ()][structure.maxX()];
        this.input = new LinkedList<EntryIngredient>(structure.getPredicates().stream().map(predicate -> EntryIngredients.of((EntryType)VanillaEntryTypes.ITEM, predicate.availableBlockItems())).toList());
        this.id = structure.m_6423_();
        this.ritual = EntryStacks.of((ItemLike)((ItemLike)Registry.f_122827_.m_7745_(this.id)));
        this.extractStructure(structure);
        this.input.add(EntryIngredient.of(this.ritual));
    }

    private void extractStructure(RitualStructure structure) {
        for (int x = 0; x < structure.maxX(); ++x) {
            for (int y = 0; y < structure.maxY(); ++y) {
                for (int z = 0; z < structure.maxZ(); ++z) {
                    char key = structure.getChar(x, y, z);
                    if (key == '$') {
                        this.structure[y][z][x] = Collections.singleton(INPUT);
                        continue;
                    }
                    if (key == '*') {
                        this.structure[y][z][x] = Collections.singleton(this.ritual);
                        continue;
                    }
                    if (key == ' ') {
                        this.structure[y][z][x] = Collections.singleton(ANY);
                        continue;
                    }
                    if (key == '.') {
                        this.structure[y][z][x] = Collections.singleton(AIR);
                        continue;
                    }
                    int finalY = y;
                    int finalZ = z;
                    int finalX = x;
                    structure.getPredicate(key).ifPresentOrElse(predicate -> {
                        this.structure[finalY][finalZ][finalX] = predicate.availableBlockItems().stream().map(stack -> {
                            EntryStack result = EntryStacks.of((ItemStack)stack);
                            result.tooltip(predicate.tooltip());
                            return result;
                        }).toList();
                    }, () -> {
                        this.structure[finalY][finalZ][finalX] = Collections.singleton(UNKNOWN);
                    });
                }
            }
        }
    }

    public int lastRead() {
        return this.lastRead;
    }

    public void lower() {
        if (this.lastRead > 0) {
            --this.lastRead;
        }
    }

    public void upper() {
        ++this.lastRead;
        if (this.lastRead >= this.structure.length) {
            this.lastRead = this.structure.length - 1;
        }
    }

    public Vec3i size() {
        if (this.structure.length == 0) {
            return new Vec3i(0, 0, 0);
        }
        if (this.structure[0].length == 0) {
            return new Vec3i(0, this.structure.length, 0);
        }
        if (this.structure[0][0].length == 0) {
            return new Vec3i(0, this.structure.length, this.structure[0].length);
        }
        return new Vec3i(this.structure[0][0].length, this.structure.length, this.structure[0].length);
    }

    public Collection<EntryStack<ItemStack>> get(int x, int y, int z) {
        if (y >= this.structure.length || y < 0) {
            return Collections.singleton(AIR);
        }
        if (z >= this.structure[y].length || z < 0) {
            return Collections.singleton(AIR);
        }
        if (x >= this.structure[y][z].length || x < 0) {
            return Collections.singleton(AIR);
        }
        return this.structure[y][z][x];
    }

    public Collection<EntryStack<ItemStack>> get(int x, int z) {
        return this.get(x, this.lastRead, z);
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredient.of(this.ritual));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return RitualStructureDisplayCategory.ID;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.id);
    }
}

