/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.config;

import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.config.RawConfig;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private Path cropPath;
    private Path packPath;
    private Path dumpPath;
    private Boolean autoReload;
    private Boolean override;
    private Boolean fruitUse;
    private Boolean infusor;
    private Boolean ritual;
    private List<String> blacklist;

    @NotNull
    public static Optional<Path> parsePath(@Nullable String path) {
        if (path == null) {
            return Optional.empty();
        }
        Path p = Path.of(path, new String[0]);
        if (p.isAbsolute()) {
            return Optional.of(p);
        }
        return Optional.of(Platform.getGameFolder().resolve(path));
    }

    @NotNull
    public static String resolvePath(@NotNull Path path) {
        Path normalizedBasePath;
        Path normalizedPath = path.normalize();
        if (normalizedPath.startsWith(normalizedBasePath = Platform.getGameFolder().normalize())) {
            return normalizedBasePath.relativize(normalizedPath).toString();
        }
        return normalizedPath.toAbsolutePath().toString();
    }

    public Config() {
        this.setCropPath(Platform.getGameFolder().resolve("crops"));
        this.setPackPath(Platform.getGameFolder().resolve("config/croparia"));
        this.setDumpPath(Platform.getGameFolder().resolve("croparia"));
        this.setAutoReload(true);
        this.setOverride(true);
        this.setFruitUse(true);
        this.setInfusor(true);
        this.setRitual(true);
        this.setBlacklist(new ArrayList<String>());
    }

    public Config(RawConfig raw) {
        this.setCropPath(Config.parsePath(raw.cropPath).orElse(Platform.getGameFolder().resolve("crops")));
        this.setPackPath(Config.parsePath(raw.packPath).orElse(Platform.getGameFolder().resolve("config/croparia")));
        this.setDumpPath(Platform.getGameFolder().resolve("croparia"));
        this.setAutoReload(raw.autoReload != null ? raw.autoReload : true);
        this.setOverride(raw.override != null ? raw.override : true);
        this.setFruitUse(raw.fruitUse != null ? raw.fruitUse : true);
        this.setInfusor(raw.infusor != null ? raw.infusor : true);
        this.setRitual(raw.ritual != null ? raw.ritual : true);
        this.setBlacklist(raw.blacklist != null ? raw.blacklist : new ArrayList<String>());
    }

    public RawConfig toRaw() {
        return new RawConfig(Config.resolvePath(this.cropPath), Config.resolvePath(this.packPath), Config.resolvePath(this.dumpPath), this.autoReload, this.override, this.fruitUse, this.infusor, this.ritual, this.blacklist);
    }

    @NotNull
    public Path getCropPath() {
        return this.cropPath;
    }

    public void setCropPath(@NotNull Path cropPath) {
        this.cropPath = cropPath;
    }

    @NotNull
    public Path getPackPath() {
        return this.packPath;
    }

    public void setPackPath(@NotNull Path packPath) {
        this.packPath = packPath;
    }

    @NotNull
    public Path getDumpPath() {
        return this.dumpPath;
    }

    public void setDumpPath(@NotNull Path dumpPath) {
        this.dumpPath = dumpPath;
    }

    @NotNull
    public Boolean getAutoReload() {
        return this.autoReload;
    }

    public void setAutoReload(@NotNull Boolean autoReload) {
        this.autoReload = autoReload;
    }

    @NotNull
    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(@NotNull Boolean override) {
        this.override = override;
    }

    @NotNull
    public Boolean getFruitUse() {
        return this.fruitUse;
    }

    public void setFruitUse(@NotNull Boolean fruitUse) {
        this.fruitUse = fruitUse;
    }

    @NotNull
    public Boolean getInfusor() {
        return this.infusor;
    }

    public void setInfusor(@NotNull Boolean infusor) {
        this.infusor = infusor;
    }

    @NotNull
    public Boolean getRitual() {
        return this.ritual;
    }

    public void setRitual(@NotNull Boolean ritual) {
        this.ritual = ritual;
    }

    @NotNull
    public List<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(@NotNull List<String> blacklist) {
        this.blacklist = blacklist;
    }

    public boolean inBlacklist(Crop crop) {
        return this.blacklist.contains(crop.getName());
    }

    public boolean inBlacklist(@NotNull String cropName, @NotNull String mod) {
        for (String pattern : this.blacklist) {
            Pattern modPattern;
            if (!(pattern.startsWith("@") ? (modPattern = Pattern.compile(pattern = pattern.substring(1))).matcher(mod).matches() : Pattern.compile(pattern).matcher(cropName).matches())) continue;
            return true;
        }
        return false;
    }
}

