/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.kubejs;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropType;
import cool.muyucloud.croparia.api.crop.block.CropariaCropBlock;
import cool.muyucloud.croparia.api.crop.item.CropFruit;
import cool.muyucloud.croparia.api.crop.item.CropSeed;
import cool.muyucloud.croparia.registry.Crops;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropRegistry {
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((String)"croparia", (ResourceKey)Registry.f_122904_);
    private final DeferredRegister<Block> blockRegistry = DeferredRegister.create((String)"croparia", (ResourceKey)Registry.f_122901_);
    @NotNull
    private final String name;

    public CropRegistry() {
        this.name = "Unnamed";
    }

    public CropRegistry(@NotNull String name) {
        this.name = name;
    }

    public void simpleCrop(@NotNull String name, @NotNull String material, int color, int tier, @Nullable String type, @Nullable String translationKey, @Nullable Map<String, String> translations) {
        CropType parsedType;
        if (type == null) {
            parsedType = CropType.CROP;
        } else {
            try {
                parsedType = CropType.valueOf(type.toUpperCase());
            }
            catch (Exception e) {
                parsedType = CropType.CROP;
            }
        }
        Crop crop = Crop.create(name, material, color, tier, parsedType, translationKey, translations).orElseThrow(() -> new IllegalArgumentException("Failed to create crop %s".formatted(name)));
        if (Crops.recordCustom(crop)) {
            RegistrySupplier cropBlock = this.blockRegistry.register(crop.getBlockId(), () -> new CropariaCropBlock(crop));
            RegistrySupplier seed = this.itemRegistry.register(crop.getSeedId(), () -> new CropSeed(crop));
            RegistrySupplier fruit = this.itemRegistry.register(crop.getFruitId(), () -> new CropFruit(crop));
            CropariaIf.LOGGER.debug("Added crop \"{}\" for CropRegistry \"{}\"", (Object)name, (Object)this.name);
        }
    }

    public void register() {
        this.blockRegistry.register();
        this.itemRegistry.register();
        CropariaIf.LOGGER.info("Finished KubeJs crop registration");
    }
}

