/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.mixin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.generator.pack.AlwaysEnabledFileResourcePackProvider;
import cool.muyucloud.croparia.api.generator.pack.DataPackHandler;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={PackRepository.class})
public abstract class PackRepositoryMixin {
    @ModifyVariable(method={"<init>(Lnet/minecraft/server/packs/repository/Pack$PackConstructor;[Lnet/minecraft/server/packs/repository/RepositorySource;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private static RepositorySource[] insertProviders(RepositorySource ... providers) {
        Path packPath = CropariaIf.CONFIG.getPackPath();
        try {
            Files.createDirectories(packPath.getParent(), new FileAttribute[0]);
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(packPath.resolve("pack.mcmeta").toFile()));
            new Gson().toJson((JsonElement)PackHandler.META, writer);
            writer.close();
        }
        catch (Throwable t) {
            CropariaIf.LOGGER.error("Failed to establish pack dir", t);
        }
        DataPackHandler.INSTANCE.beforeReload();
        RepositorySource[] newProviders = new RepositorySource[providers.length + 1];
        AlwaysEnabledFileResourcePackProvider provider = DataPackHandler.INSTANCE.getDatapack();
        newProviders[0] = provider;
        System.arraycopy(providers, 0, newProviders, 1, providers.length);
        return newProviders;
    }
}

