/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.registry;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.annotation.PostReg;
import cool.muyucloud.croparia.annotation.PreReg;
import cool.muyucloud.croparia.api.core.block.Greenhouse;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.block.Placeholder;
import cool.muyucloud.croparia.api.core.block.RitualStand;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.block.CropariaCropBlock;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import cool.muyucloud.croparia.api.element.block.ElementalLiquidBlock;
import cool.muyucloud.croparia.registry.Fluids;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.NotNull;

public class CropariaBlocks {
    @PreReg
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"croparia", (ResourceKey)Registry.f_122901_);
    @PostReg
    public static final RegistrySupplier<Placeholder> PLACEHOLDER = CropariaBlocks.registerBlock("placeholder_block", Placeholder::new);
    @PostReg
    public static final RegistrySupplier<Greenhouse> GREENHOUSE = CropariaBlocks.registerBlock("greenhouse", () -> new Greenhouse(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(1.0f, 1.0f).m_60977_().m_60953_(state -> 8).m_60960_((state, world, pos) -> false).m_60971_((state, world, pos) -> false)));
    @PostReg
    public static final RegistrySupplier<Infusor> INFUSOR = CropariaBlocks.registerBlock("infusor", Infusor::new);
    @PostReg
    public static final RegistrySupplier<RitualStand> RITUAL_STAND = CropariaBlocks.registerBlock("ritual_stand", () -> new RitualStand(1));
    @PostReg
    public static final RegistrySupplier<RitualStand> RITUAL_STAND_2 = CropariaBlocks.registerBlock("ritual_stand_2", () -> new RitualStand(2));
    @PostReg
    public static final RegistrySupplier<RitualStand> RITUAL_STAND_3 = CropariaBlocks.registerBlock("ritual_stand_3", () -> new RitualStand(3));
    @PostReg
    public static final RegistrySupplier<Block> ELEMENTAL_STONE = CropariaBlocks.registerBlock("elemental_stone", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.0f, 1.0f).m_60999_()));
    @PostReg
    public static final RegistrySupplier<OreBlock> ELEMATILIUS_ORE = CropariaBlocks.registerBlock("elematilius_ore", () -> new OreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.0f, 1.0f).m_60999_(), UniformInt.m_146622_((int)0, (int)2)));
    @PostReg
    public static final RegistrySupplier<OreBlock> DEEPSLATE_ELEMATILIUS_ORE = CropariaBlocks.registerBlock("deepslate_elematilius_ore", () -> new OreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.0f, 1.0f).m_60999_().m_155949_(MaterialColor.f_164534_).m_60918_(SoundType.f_154677_).m_60999_(), UniformInt.m_146622_((int)0, (int)2)));
    @PostReg
    public static final RegistrySupplier<ElementalLiquidBlock> FLUID_ELEMATILIUS = CropariaBlocks.registerBlock("fluid_elematilius", () -> new ElementalLiquidBlock(ElementsEnum.ELEMENTAL, (Supplier<? extends FlowingFluid>)Fluids.ELEMATILIUS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    @PostReg
    public static final RegistrySupplier<ElementalLiquidBlock> FLUID_EARTH = CropariaBlocks.registerBlock("fluid_earth", () -> new ElementalLiquidBlock(ElementsEnum.EARTH, (Supplier<? extends FlowingFluid>)Fluids.EARTH, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    @PostReg
    public static final RegistrySupplier<ElementalLiquidBlock> FLUID_WATER = CropariaBlocks.registerBlock("fluid_water", () -> new ElementalLiquidBlock(ElementsEnum.WATER, (Supplier<? extends FlowingFluid>)Fluids.WATER, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    @PostReg
    public static final RegistrySupplier<ElementalLiquidBlock> FLUID_FIRE = CropariaBlocks.registerBlock("fluid_fire", () -> new ElementalLiquidBlock(ElementsEnum.FIRE, (Supplier<? extends FlowingFluid>)Fluids.FIRE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    @PostReg
    public static final RegistrySupplier<ElementalLiquidBlock> FLUID_AIR = CropariaBlocks.registerBlock("fluid_air", () -> new ElementalLiquidBlock(ElementsEnum.AIR, (Supplier<? extends FlowingFluid>)Fluids.AIR, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));

    @PreReg
    @NotNull
    public static <T extends Block> RegistrySupplier<T> registerBlock(@NotNull String name, @NotNull Supplier<T> supplier) {
        return BLOCKS.register(name, supplier);
    }

    @PreReg
    public static void registerCrop(@NotNull Crop crop) {
        BLOCKS.register(crop.getBlockId(), () -> new CropariaCropBlock(crop));
    }

    @PreReg
    public static void register() {
        CropariaIf.LOGGER.debug("Registering blocks");
        BLOCKS.register();
    }
}

