/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.registry;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.annotation.PostReg;
import cool.muyucloud.croparia.annotation.PreReg;
import cool.muyucloud.croparia.api.core.item.GreenhouseItem;
import cool.muyucloud.croparia.api.core.item.Placeholder;
import cool.muyucloud.croparia.api.core.item.RecipeWizard;
import cool.muyucloud.croparia.api.core.item.relic.HornPlenty;
import cool.muyucloud.croparia.api.core.item.relic.InfiniteApple;
import cool.muyucloud.croparia.api.core.item.relic.MagicRope;
import cool.muyucloud.croparia.api.core.item.relic.MidasHand;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.item.CropFruit;
import cool.muyucloud.croparia.api.crop.item.CropSeed;
import cool.muyucloud.croparia.api.crop.item.Croparia;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import cool.muyucloud.croparia.api.element.item.Elematilius;
import cool.muyucloud.croparia.api.element.item.ElementalBucket;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.Fluids;
import cool.muyucloud.croparia.registry.Tabs;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class CropariaItems {
    @PreReg
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"croparia", (ResourceKey)Registry.f_122904_);
    @PostReg
    public static final RegistrySupplier<RecipeWizard> RECIPE_WIZARD = CropariaItems.registerItem("recipe_wizard", () -> new RecipeWizard(new Item.Properties().m_41491_(Tabs.MAIN).m_41487_(1).m_41497_(Rarity.UNCOMMON)));
    @PostReg
    public static final RegistrySupplier<BlockItem> PLACEHOLDER_BLOCK = CropariaItems.registerItem("placeholder_block", () -> new BlockItem((Block)CropariaBlocks.PLACEHOLDER.get(), new Item.Properties()));
    @PostReg
    public static final RegistrySupplier<Placeholder> PLACEHOLDER = CropariaItems.registerItem("placeholder", Placeholder::new);
    @PostReg
    public static final RegistrySupplier<BlockItem> GREENHOUSE = CropariaItems.registerItem("greenhouse", () -> new GreenhouseItem((Block)CropariaBlocks.GREENHOUSE.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> INFUSOR = CropariaItems.registerItem("infusor", () -> new BlockItem((Block)CropariaBlocks.INFUSOR.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> RITUAL_STAND = CropariaItems.registerItem("ritual_stand", () -> new BlockItem((Block)CropariaBlocks.RITUAL_STAND.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> RITUAL_STAND_2 = CropariaItems.registerItem("ritual_stand_2", () -> new BlockItem((Block)CropariaBlocks.RITUAL_STAND_2.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> RITUAL_STAND_3 = CropariaItems.registerItem("ritual_stand_3", () -> new BlockItem((Block)CropariaBlocks.RITUAL_STAND_3.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> ELEMENTAL_STONE = CropariaItems.registerItem("elemental_stone", () -> new BlockItem((Block)CropariaBlocks.ELEMENTAL_STONE.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> ELEMATILIUS_ORE = CropariaItems.registerItem("elematilius_ore", () -> new BlockItem((Block)CropariaBlocks.ELEMATILIUS_ORE.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<BlockItem> DEEPSLATE_ELEMATILIUS_ORE = CropariaItems.registerItem("deepslate_elematilius_ore", () -> new BlockItem((Block)CropariaBlocks.DEEPSLATE_ELEMATILIUS_ORE.get(), new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<ElementalPotion> POTION_ELEMATILIUS = CropariaItems.registerItem("potion_elematilius", () -> new ElementalPotion(ElementsEnum.ELEMENTAL, new Item.Properties().m_41491_(Tabs.MAIN).m_41495_(Items.f_42590_)));
    public static final RegistrySupplier<ElementalPotion> POTION_WATER = CropariaItems.registerItem("potion_water", () -> new ElementalPotion(ElementsEnum.WATER, new Item.Properties().m_41491_(Tabs.MAIN).m_41495_(Items.f_42590_)));
    public static final RegistrySupplier<ElementalPotion> POTION_FIRE = CropariaItems.registerItem("potion_fire", () -> new ElementalPotion(ElementsEnum.FIRE, new Item.Properties().m_41491_(Tabs.MAIN).m_41495_(Items.f_42590_)));
    public static final RegistrySupplier<ElementalPotion> POTION_EARTH = CropariaItems.registerItem("potion_earth", () -> new ElementalPotion(ElementsEnum.EARTH, new Item.Properties().m_41491_(Tabs.MAIN).m_41495_(Items.f_42590_)));
    public static final RegistrySupplier<ElementalPotion> POTION_AIR = CropariaItems.registerItem("potion_air", () -> new ElementalPotion(ElementsEnum.AIR, new Item.Properties().m_41491_(Tabs.MAIN).m_41495_(Items.f_42590_)));
    @PostReg
    public static final RegistrySupplier<Elematilius> ELEMATILIUS = CropariaItems.registerItem("elematilius", () -> new Elematilius(ElementsEnum.ELEMENTAL, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Elematilius> ELEMENTAL_FIRE = CropariaItems.registerItem("elemental_fire", () -> new Elematilius(ElementsEnum.FIRE, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Elematilius> ELEMENTAL_WATER = CropariaItems.registerItem("elemental_water", () -> new Elematilius(ElementsEnum.WATER, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Elematilius> ELEMENTAL_EARTH = CropariaItems.registerItem("elemental_earth", () -> new Elematilius(ElementsEnum.EARTH, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Elematilius> ELEMENTAL_AIR = CropariaItems.registerItem("elemental_air", () -> new Elematilius(ElementsEnum.AIR, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA = CropariaItems.registerItem("croparia", () -> new Croparia(1, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA2 = CropariaItems.registerItem("croparia2", () -> new Croparia(2, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA3 = CropariaItems.registerItem("croparia3", () -> new Croparia(3, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA4 = CropariaItems.registerItem("croparia4", () -> new Croparia(4, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA5 = CropariaItems.registerItem("croparia5", () -> new Croparia(5, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA6 = CropariaItems.registerItem("croparia6", () -> new Croparia(6, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA7 = CropariaItems.registerItem("croparia7", () -> new Croparia(7, new Item.Properties().m_41491_(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<HornPlenty> HORN = CropariaItems.registerItem("horn_plenty", HornPlenty::new);
    @PostReg
    public static final RegistrySupplier<InfiniteApple> INFINITE_APPLE = CropariaItems.registerItem("infinite_apple", InfiniteApple::new);
    @PostReg
    public static final RegistrySupplier<MagicRope> MAGIC_ROPE = CropariaItems.registerItem("magic_rope", MagicRope::new);
    @PostReg
    public static final RegistrySupplier<MidasHand> MIDAS_HAND = CropariaItems.registerItem("midas_hand", MidasHand::new);
    @PostReg
    public static final RegistrySupplier<Item> ELEMATILIUS_BUCKET = CropariaItems.registerItem("elematilius_bucket", () -> new ElementalBucket(ElementsEnum.ELEMENTAL, (Supplier<? extends Fluid>)Fluids.ELEMATILIUS, new Item.Properties().m_41491_(Tabs.MAIN).m_41487_(1).m_41495_(Items.f_42446_)));
    @PostReg
    public static final RegistrySupplier<Item> EARTH_BUCKET = CropariaItems.registerItem("earth_bucket", () -> new ElementalBucket(ElementsEnum.EARTH, (Supplier<? extends Fluid>)Fluids.EARTH, new Item.Properties().m_41491_(Tabs.MAIN).m_41487_(1).m_41495_(Items.f_42446_)));
    @PostReg
    public static final RegistrySupplier<Item> WATER_BUCKET = CropariaItems.registerItem("water_bucket", () -> new ElementalBucket(ElementsEnum.WATER, (Supplier<? extends Fluid>)Fluids.WATER, new Item.Properties().m_41491_(Tabs.MAIN).m_41487_(1).m_41495_(Items.f_42446_)));
    @PostReg
    public static final RegistrySupplier<Item> FIRE_BUCKET = CropariaItems.registerItem("fire_bucket", () -> new ElementalBucket(ElementsEnum.FIRE, (Supplier<? extends Fluid>)Fluids.FIRE, new Item.Properties().m_41491_(Tabs.MAIN).m_41487_(1).m_41495_(Items.f_42446_)));
    @PostReg
    public static final RegistrySupplier<Item> AIR_BUCKET = CropariaItems.registerItem("air_bucket", () -> new ElementalBucket(ElementsEnum.AIR, (Supplier<? extends Fluid>)Fluids.AIR, new Item.Properties().m_41491_(Tabs.MAIN).m_41487_(1).m_41495_(Items.f_42446_)));
    @PostReg
    protected static final List<RegistrySupplier<Item>> CROPARIAS = List.of(CROPARIA, CROPARIA2, CROPARIA3, CROPARIA4, CROPARIA5, CROPARIA6, CROPARIA7);
    @PostReg
    protected static final List<RegistrySupplier<BlockItem>> RITUAL_STANDS = List.of(RITUAL_STAND, RITUAL_STAND_2, RITUAL_STAND_3);

    @PreReg
    public static void registerCrop(@NotNull Crop crop) {
        ITEMS.register(crop.getSeedId(), () -> new CropSeed(crop));
        ITEMS.register(crop.getFruitId(), () -> new CropFruit(crop));
    }

    @PreReg
    @NotNull
    @PostReg
    public static <T extends Item> RegistrySupplier<T> registerItem(@NotNull String name, @NotNull Supplier<T> supplier) {
        return ITEMS.register(name, supplier);
    }

    @PreReg
    public static void register() {
        CropariaIf.LOGGER.debug("Registering items");
        ITEMS.register();
    }

    @NotNull
    @PostReg
    public static RegistrySupplier<Item> getCroparia(int tier) {
        return CROPARIAS.get(tier - 1);
    }

    public static int leastTier() {
        return 1;
    }

    public static int mostTier() {
        return CROPARIAS.size();
    }

    @NotNull
    @PostReg
    public static RegistrySupplier<BlockItem> getRitualStand(int tier) {
        return RITUAL_STANDS.get(tier - 1);
    }
}

