/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.registry;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropFileHandler;
import cool.muyucloud.croparia.api.crop.CropType;
import cool.muyucloud.croparia.api.crop.RawCrop;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import dev.architectury.platform.Platform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Crops {
    protected static final Map<String, Crop> CROPS = new HashMap<String, Crop>();
    protected static final Map<String, Crop> BUILTIN_CROPS = new HashMap<String, Crop>();
    public static final Crop ELEMENTAL = Crops.croparia("elemental", "croparia:elematilius", 7414665, 2, CropType.CROP, "item.croparia.elematilius");
    public static final Crop EARTH = Crops.croparia("earth", "croparia:elemental_earth", 15059131, 3, CropType.CROP, "item.croparia.elemental_earth");
    public static final Crop WATER = Crops.croparia("water", "croparia:elemental_water", 2775730, 4, CropType.CROP, "item.croparia.elemental_water");
    public static final Crop FIRE = Crops.croparia("fire", "croparia:elemental_fire", 12998999, 6, CropType.CROP, "item.croparia.elemental_fire");
    public static final Crop AIR = Crops.croparia("air", "croparia:elemental_air", 10660277, 7, CropType.CROP, "item.croparia.elemental_air");
    public static final Crop COAL = Crops.vanilla("coal", Items.f_42413_, 0x333333, 1, CropType.CROP);
    public static final Crop IRON = Crops.vanilla("iron", Items.f_42416_, 0xD8D8D8, 2, CropType.CROP);
    public static final Crop GOLD = Crops.vanilla("gold", Items.f_42417_, 0xFFFF8B, 2, CropType.CROP);
    public static final Crop LAPIS = Crops.vanilla("lapis", Items.f_42534_, 7641066, 3, CropType.CROP);
    public static final Crop REDSTONE = Crops.vanilla("redstone", Items.f_42451_, 0xFF2626, 3, CropType.CROP);
    public static final Crop DIAMOND = Crops.vanilla("diamond", Items.f_42415_, 9237730, 4, CropType.CROP);
    public static final Crop EMERALD = Crops.vanilla("emerald", Items.f_42616_, 1564002, 4, CropType.CROP);
    public static final Crop CLAY = Crops.vanilla("clay", Items.f_41983_, 10134451, 1, CropType.CROP);
    public static final Crop GLOWSTONE = Crops.vanilla("glowstone", Items.f_42054_, 0xFFFF00, 3, CropType.CROP);
    public static final Crop QUARTZ = Crops.vanilla("quartz", Items.f_42692_, 14670031, 3, CropType.CROP);
    public static final Crop SHARD = Crops.vanilla("shard", Items.f_42695_, 7583146, 2, CropType.CROP);
    public static final Crop CRYSTAL = Crops.vanilla("crystal", Items.f_42696_, 13363168, 2, CropType.CROP);
    public static final Crop ENDER = Crops.vanilla("ender", Items.f_42584_, 9237730, 3, CropType.MONSTER);
    public static final Crop BONE = Crops.vanilla("bone", Items.f_42500_, 15526601, 2, CropType.MONSTER);
    public static final Crop EYE = Crops.vanilla("eye", Items.f_42591_, 15526601, 2, CropType.MONSTER);
    public static final Crop POWDER = Crops.vanilla("powder", Items.f_42403_, 0x727272, 2, CropType.MONSTER);
    public static final Crop PAPER = Crops.vanilla("paper", Items.f_42516_, 0xEAEAEA, 1, CropType.CROP);
    public static final Crop SUGAR = Crops.vanilla("sugar", Items.f_42501_, 0xF5FFFF, 1, CropType.CROP);
    public static final Crop CHARCOAL = Crops.vanilla("charcoal", Items.f_42414_, 5458234, 1, CropType.CROP);
    public static final Crop FLINT = Crops.vanilla("flint", Items.f_42484_, 0x565656, 1, CropType.CROP);
    public static final Crop SNOWBALL = Crops.vanilla("snowball", Items.f_42452_, 0xFBFFFF, 1, CropType.CROP);
    public static final Crop FIREWORK = Crops.vanilla("firework", Items.f_42689_, 0x575757, 1, CropType.CROP);
    public static final Crop NETHER = Crops.vanilla("nether", Items.f_42691_, 4597292, 3, CropType.CROP);
    public static final Crop BOTTLE = Crops.vanilla("bottle", Items.f_42590_, 0xE4E4E4, 1, CropType.CROP);
    public static final Crop FOOT = Crops.vanilla("foot", Items.f_42648_, 13609336, 1, CropType.ANIMAL);
    public static final Crop HIDE = Crops.vanilla("hide", Items.f_42649_, 13082215, 1, CropType.ANIMAL);
    public static final Crop LEATHER = Crops.vanilla("leather", Items.f_42454_, 12999733, 1, CropType.ANIMAL);
    public static final Crop FEATHER = Crops.vanilla("feather", Items.f_42402_, 0xFFFFFF, 1, CropType.ANIMAL);
    public static final Crop BLAZE = Crops.vanilla("blaze", Items.f_42585_, 16763648, 3, CropType.MONSTER);
    public static final Crop GHAST = Crops.vanilla("ghast", Items.f_42586_, 14941672, 4, CropType.MONSTER);
    public static final Crop MAGMA = Crops.vanilla("magma", Items.f_42542_, 13541413, 3, CropType.MONSTER);
    public static final Crop SHELL = Crops.vanilla("shell", Items.f_42748_, 10384542, 4, CropType.MONSTER);
    public static final Crop STAR = Crops.vanilla("star", Items.f_42686_, 0xF0F3F3, 6, CropType.MONSTER);
    public static final Crop STRING = Crops.vanilla("string", Items.f_42401_, 0xF7F7F7, 2, CropType.MONSTER);
    public static final Crop SLIME = Crops.vanilla("slime", Items.f_42518_, 8702067, 2, CropType.MONSTER);
    public static final Crop ZOMBIE = Crops.vanilla("zombie", Items.f_42583_, 12410167, 2, CropType.MONSTER);
    public static final Crop VINE = Crops.vanilla("vine", Items.f_42029_, 1787145, 1, CropType.NATURE);
    public static final Crop WEEPING_VINES = Crops.vanilla("weeping_vines", Items.f_41907_, 0x7A0000, 1, CropType.NATURE);
    public static final Crop TWISTING_VINES = Crops.vanilla("twisting_vines", Items.f_41908_, 1356419, 1, CropType.NATURE);
    public static final Crop LILY_PAD = Crops.vanilla("lilypad", Items.f_42094_, 810772, 1, CropType.NATURE);
    public static final Crop BUSH = Crops.vanilla("bush", Items.f_41866_, 9724968, 1, CropType.NATURE);
    public static final Crop GRASS = Crops.vanilla("grass", Items.f_41864_, 136335627, 1, CropType.NATURE);
    public static final Crop LARGE_FERN = Crops.vanilla("large_fern", Items.f_42211_, 4878912, 1, CropType.NATURE);
    public static final Crop TALL_GRASS = Crops.vanilla("tall_grass", Items.f_42210_, 3098408, 1, CropType.NATURE);
    public static final Crop FERN = Crops.vanilla("fern", Items.f_41865_, 1787145, 1, CropType.NATURE);
    public static final Crop OAK = Crops.vanilla("oak", Items.f_42647_, 10322508, 1, CropType.NATURE);
    public static final Crop SPRUCE = Crops.vanilla("spruce", Items.f_42700_, 7952691, 1, CropType.NATURE);
    public static final Crop BIRCH = Crops.vanilla("birch", Items.f_42753_, 13022585, 1, CropType.NATURE);
    public static final Crop JUNGLE = Crops.vanilla("jungle", Items.f_42794_, 12422250, 1, CropType.NATURE);
    public static final Crop ACACIA = Crops.vanilla("acacia", Items.f_42795_, 12083766, 1, CropType.NATURE);
    public static final Crop DARK_OAK = Crops.vanilla("dark_oak", Items.f_42796_, 5124376, 1, CropType.NATURE);
    public static final Crop CRIMSON = Crops.vanilla("crimson", Items.f_42797_, 5975873, 1, CropType.NATURE);
    public static final Crop WARPED = Crops.vanilla("warped", Items.f_42798_, 3703168, 1, CropType.NATURE);
    public static final Crop APPLE = Crops.vanilla("apple", Items.f_42410_, 16718891, 1, CropType.FOOD);
    public static final Crop GOLDEN_APPLE = Crops.vanilla("golden_apple", Items.f_42436_, 0xFFFFB0, 3, CropType.FOOD);
    public static final Crop BREAD = Crops.vanilla("bread", Items.f_42406_, 10384165, 1, CropType.FOOD);
    public static final Crop EGG = Crops.vanilla("egg", Items.f_42521_, 14667419, 1, CropType.FOOD);
    public static final Crop TURTLE_EGG = Crops.vanilla("turtle_egg", Items.f_42279_, 5820079, 1, CropType.FOOD);
    public static final Crop TROPICAL_FISH = Crops.vanilla("clownfish", Items.f_42528_, 15898981, 1, CropType.FOOD);
    public static final Crop PUFFER_FISH = Crops.vanilla("pufferfish", Items.f_42529_, 12956160, 1, CropType.FOOD);
    public static final Crop COOKIE = Crops.vanilla("cookie", Items.f_42572_, 14254910, 1, CropType.FOOD);
    public static final Crop CHORUS = Crops.vanilla("chorus", Items.f_42730_, 0xAA85AA, 3, CropType.FOOD);
    public static final Crop BEEF = Crops.vanilla("raw_beef", Items.f_42579_, 14829888, 1, CropType.FOOD);
    public static final Crop PORKSHOP = Crops.vanilla("raw_porc", Items.f_42485_, 0xFF8C8C, 1, CropType.FOOD);
    public static final Crop COD = Crops.vanilla("fish", Items.f_42526_, 13017713, 1, CropType.FOOD);
    public static final Crop SALMON = Crops.vanilla("salmon", Items.f_42527_, 10373961, 1, CropType.FOOD);
    public static final Crop RAW_CHICKEN = Crops.vanilla("raw_chicken", Items.f_42581_, 15711404, 1, CropType.FOOD);
    public static final Crop RAW_RABBIT = Crops.vanilla("raw_rabbit", Items.f_42697_, 15578790, 1, CropType.FOOD);
    public static final Crop RAW_MUTTON = Crops.vanilla("raw_mutton", Items.f_42658_, 15031378, 1, CropType.FOOD);
    public static final Crop BROWN_MUSHROOM = Crops.vanilla("brown_mushroom", Items.f_41952_, 13277047, 1, CropType.FOOD);
    public static final Crop RED_MUSHROOM = Crops.vanilla("red_mushroom", Items.f_41953_, 14619154, 1, CropType.FOOD);
    public static final Crop CRIMSON_FUNGUS = Crops.vanilla("crimson_fungus", Items.f_41954_, 10626088, 1, CropType.FOOD);
    public static final Crop WARPED_FUNGUS = Crops.vanilla("warped_fungus", Items.f_41955_, 1356419, 1, CropType.FOOD);
    public static final Crop ORANGE = Crops.vanilla("orange", Items.f_42536_, 16738816, 1, CropType.CROP);
    public static final Crop MAGENTA = Crops.vanilla("magenta", Items.f_42537_, 16711900, 1, CropType.CROP);
    public static final Crop LIGHT_BLUE = Crops.vanilla("light_blue", Items.f_42538_, 38143, 1, CropType.CROP);
    public static final Crop YELLOW = Crops.vanilla("yellow", Items.f_42539_, 16766976, 1, CropType.CROP);
    public static final Crop LIME = Crops.vanilla("lime", Items.f_42540_, 11992832, 1, CropType.CROP);
    public static final Crop PINK = Crops.vanilla("pink", Items.f_42489_, 16744374, 1, CropType.CROP);
    public static final Crop GRAY = Crops.vanilla("gray", Items.f_42490_, 0x404040, 1, CropType.CROP);
    public static final Crop LIGHT_GRAY = Crops.vanilla("light_gray", Items.f_42491_, 0x808080, 1, CropType.CROP);
    public static final Crop CYAN = Crops.vanilla("cyan", Items.f_42492_, 65535, 1, CropType.CROP);
    public static final Crop PURPLE = Crops.vanilla("purple", Items.f_42493_, 11665663, 1, CropType.CROP);
    public static final Crop BROWN = Crops.vanilla("brown", Items.f_42495_, 8336128, 1, CropType.CROP);
    public static final Crop GREEN = Crops.vanilla("green", Items.f_42496_, 32526, 1, CropType.CROP);
    public static final Crop RED = Crops.vanilla("red", Items.f_42497_, 0xFF0000, 1, CropType.CROP);
    public static final Crop BLACK = Crops.vanilla("black", Items.f_42498_, 0x2D2D2D, 1, CropType.CROP);
    public static final Crop TOTEM = Crops.vanilla("totem", Items.f_42747_, 16314021, 6, CropType.CROP);
    public static final Crop TETHER = Crops.vanilla("tether", Items.f_42655_, 11308665, 1, CropType.CROP);
    public static final Crop NAME_TAG = Crops.vanilla("name_tag", Items.f_42656_, 8024418, 1, CropType.CROP);
    public static final Crop XP = Crops.vanilla("xp", Items.f_42612_, 12255049, 4, CropType.CROP);
    public static final Crop SEA = Crops.vanilla("sea", Items.f_42716_, 2070193, 4, CropType.CROP);
    public static final Crop SCUTE = Crops.vanilla("scute", Items.f_42355_, 4702026, 2, CropType.ANIMAL);
    public static final Crop NAUTILUS = Crops.vanilla("nautilus", Items.f_42715_, 13946051, 3, CropType.CROP);
    public static final Crop PHANTOM = Crops.vanilla("phantom", Items.f_42714_, 14473664, 2, CropType.MONSTER);
    public static final Crop WITHER = Crops.vanilla("wither", Items.f_41951_, 2760473, 5, CropType.MONSTER);
    public static final Crop DRAGON = Crops.vanilla("dragon", Items.f_42104_, 2949427, 7, CropType.MONSTER);
    public static final Crop BLUE = Crops.vanilla("blue", Items.f_42494_, 9983, 1, CropType.CROP);
    public static final Crop INK = Crops.vanilla("ink", Items.f_42532_, 3486801, 1, CropType.ANIMAL);
    public static final Crop WHITE = Crops.vanilla("white", Items.f_42535_, 0xFFFFFF, 1, CropType.CROP);
    public static final Crop HONEYCOMB = Crops.vanilla("honeycomb", Items.f_42784_, 16432937, 1, CropType.ANIMAL);
    public static final Crop NETHERITE = Crops.vanilla("netherite", Items.f_42418_, 6637376, 5, CropType.CROP);
    public static final Crop GLOW_INK = Crops.vanilla("glowink", Items.f_151056_, 4972218, 2, CropType.CROP);
    public static final Crop COPPER = Crops.vanilla("copper", Items.f_151052_, 16499638, 2, CropType.CROP);
    public static final Crop AMETHYST = Crops.vanilla("amethyst", Items.f_151049_, 14273522, 3, CropType.CROP);

    public static int size() {
        return CROPS.size();
    }

    public static int builtinSize() {
        return BUILTIN_CROPS.size();
    }

    @Nullable
    public static Crop forName(@NotNull String name) {
        return CROPS.get(name);
    }

    public static Collection<String> cropNames() {
        return Collections.unmodifiableSet(CROPS.keySet());
    }

    public static void forEachCrop(@NotNull Consumer<Crop> consumer) {
        CROPS.values().forEach(consumer);
    }

    public static void forEachBuiltinCrop(@NotNull Consumer<Crop> consumer) {
        BUILTIN_CROPS.values().forEach(consumer);
    }

    protected static void recordBuiltin(Crop crop) {
        if (CROPS.containsKey(crop.getName())) {
            CropariaIf.LOGGER.error("Built-in crop \"{}\" already exists", (Object)crop.getName());
            return;
        }
        BUILTIN_CROPS.put(crop.getName(), crop);
        CROPS.put(crop.getName(), crop);
    }

    public static boolean recordCustom(Crop crop) {
        boolean r = true;
        if (CROPS.containsKey(crop.getName())) {
            CropariaIf.LOGGER.info("Replace existing crop \"{}\"", (Object)crop);
            r = false;
        }
        CROPS.put(crop.getName(), crop);
        return r;
    }

    public static CompletableFuture<Suggestions> suggestCrops(SuggestionsBuilder builder) {
        for (String name : Crops.cropNames()) {
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    public static boolean containsCrop(String name) {
        return CROPS.containsKey(name);
    }

    @NotNull
    public static Crop croparia(@NotNull String name, @NotNull String materialId, int color, int tier, @NotNull CropType type, @NotNull String translationKey) {
        Crop crop = Crop.create(name, materialId, color, tier, type, translationKey, Map.of()).orElseThrow(() -> new IllegalArgumentException("Vanilla crop \"%s\" failed to create".formatted(name)));
        if (CropariaIf.CONFIG.inBlacklist(name, "croparia")) {
            CropariaIf.LOGGER.info("Skipped croparia crop \"{}\" due to blacklist", (Object)name);
        } else {
            Crops.recordBuiltin(crop);
        }
        return crop;
    }

    @NotNull
    public static Crop vanilla(@NotNull String name, Item material, int color, int tier, @NotNull CropType type) {
        Crop crop = Crop.create(name, Objects.requireNonNull(material.arch$registryName()).toString(), color, tier, type, material.m_5524_(), Map.of()).orElseThrow(() -> new IllegalArgumentException("Vanilla crop %s failed to create".formatted(name)));
        if (CropariaIf.CONFIG.inBlacklist(name, "minecraft")) {
            CropariaIf.LOGGER.debug("Skipped vanilla crop \"{}\" due to blacklist", (Object)name);
        } else {
            Crops.recordBuiltin(crop);
        }
        return crop;
    }

    @Nullable
    public static Crop compat(String name, String material, int color, int tier, CropType type, @NotNull Map<String, String> translationKeys) {
        for (String mod : translationKeys.keySet()) {
            if (!Platform.isModLoaded((String)mod) || CropariaIf.CONFIG.inBlacklist(name, mod)) continue;
            Crop crop = Crop.create(name, material, color, tier, type, translationKeys.get(mod), Map.of()).orElseThrow(() -> new AssertionError((Object)"Compat crop \"%s\" failed to create".formatted(name)));
            Crops.recordBuiltin(crop);
            return crop;
        }
        CropariaIf.LOGGER.debug("Skipped compat crop \"{}\" due to blacklist or missing dependencies", (Object)name);
        return null;
    }

    public static boolean shouldLoad(@NotNull List<List<String>> dependencies) {
        return dependencies.isEmpty() || dependencies.stream().allMatch(list -> list.isEmpty() || list.stream().anyMatch(Platform::isModLoaded));
    }

    @SafeVarargs
    public static boolean shouldLoad(List<String> ... dependencies) {
        return dependencies.length == 0 || Arrays.stream(dependencies).allMatch(list -> list.isEmpty() || list.stream().anyMatch(Platform::isModLoaded));
    }

    public static void register() {
        CropariaIf.LOGGER.info("Loading custom crops from file definitions");
        CropFileHandler.readCrops().forEach(Crops::registerFileCrop);
        CropariaIf.LOGGER.info("Registering built-in crops");
        for (Crop crop : BUILTIN_CROPS.values()) {
            if (CropariaIf.CONFIG.inBlacklist(crop)) continue;
            CropariaItems.registerCrop(crop);
            CropariaBlocks.registerCrop(crop);
        }
    }

    private static void registerFileCrop(@NotNull RawCrop raw) {
        if (raw.dependencies == null || Crops.shouldLoad(raw.dependencies)) {
            Crop.of(raw).ifPresentOrElse(crop -> {
                if (Crops.recordCustom(crop)) {
                    CropariaItems.registerCrop(crop);
                    CropariaBlocks.registerCrop(crop);
                }
            }, () -> CropariaIf.LOGGER.error("Inadequate or invalid arguments for custom crop \"{}\" from file definition", (Object)raw.name));
        } else {
            CropariaIf.LOGGER.debug("Skipped custom crop \"{}\" from file definition due to missing dependencies {}", (Object)raw.name, raw.dependencies);
        }
    }
}

