/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiOptional<L, R> {
    @Nullable
    private final L left;
    @Nullable
    private final R right;

    public BiOptional(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    public void ifEither(@NotNull Consumer<L> ifLeft, @NotNull Consumer<R> ifRight) {
        this.ifEither(ifLeft, ifRight, () -> {});
    }

    public void ifEither(@NotNull Consumer<L> ifLeft, @NotNull Consumer<R> ifRight, @NotNull Runnable orElse) {
        this.ifEither(ifLeft, ifRight, (l, r) -> orElse.run(), orElse);
    }

    public void ifEither(Consumer<L> ifLeft, Consumer<R> ifRight, BiConsumer<L, R> ifBoth, Runnable ifNeither) {
        if (this.left != null && this.right != null) {
            ifBoth.accept(this.left, this.right);
            return;
        }
        if (this.left != null) {
            ifLeft.accept(this.left);
            return;
        }
        if (this.right != null) {
            ifRight.accept(this.right);
            return;
        }
        ifNeither.run();
    }

    public void ifAny(@NotNull Consumer<L> ifLeft, @NotNull Consumer<R> ifRight) {
        if (this.left != null) {
            ifLeft.accept(this.left);
        }
        if (this.right != null) {
            ifRight.accept(this.right);
        }
    }

    public void ifAny(@NotNull Consumer<L> ifLeft, @NotNull Consumer<R> ifRight, @NotNull Runnable ifNeither) {
        if (this.left != null) {
            ifLeft.accept(this.left);
            return;
        }
        if (this.right != null) {
            ifRight.accept(this.right);
            return;
        }
        ifNeither.run();
    }

    public boolean isBoth() {
        return this.left != null && this.right != null;
    }

    public boolean isNeither() {
        return this.left == null && this.right == null;
    }

    public boolean hasLeft() {
        return this.left != null;
    }

    public boolean hasRight() {
        return this.right != null;
    }

    public boolean isLeft() {
        return this.left != null && this.right == null;
    }

    public boolean isRight() {
        return this.left == null && this.right != null;
    }

    public boolean isAny() {
        return this.left != null || this.right != null;
    }

    public void ifLeft(Consumer<L> ifLeft) {
        if (this.left != null) {
            ifLeft.accept(this.left);
        }
    }

    public void ifRight(Consumer<R> ifRight) {
        if (this.right != null) {
            ifRight.accept(this.right);
        }
    }

    public void ifBoth(BiConsumer<L, R> biConsumer) {
        if (this.left != null && this.right != null) {
            biConsumer.accept(this.left, this.right);
        }
    }

    public void ifNeither(Consumer<String> onError) {
        if (this.left == null && this.right == null) {
            onError.accept("Both left and right are null");
        }
    }

    public static <L, R> BiOptional<L, R> of(@Nullable L left, @Nullable R right) {
        return new BiOptional<L, R>(left, right);
    }

    public static <L, R> BiOptional<L, R> ofEmpty() {
        return new BiOptional<Object, Object>(null, null);
    }
}

