/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static boolean anyNull(Object ... objects) {
        return Arrays.stream(objects).anyMatch(Objects::isNull);
    }

    public static void deleteDir(File dir) throws IOException {
        if (dir.isDirectory()) {
            for (File child : Objects.requireNonNull(dir.listFiles())) {
                Util.deleteDir(child);
            }
        }
        Files.delete(dir.toPath());
    }

    public static BlockPos lookingAt(@NotNull Player player) {
        Level world = player.m_183503_();
        ClipContext context = new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(player.m_20154_().m_82542_(5.0, 5.0, 5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = world.m_45547_(context);
        return result.m_82425_();
    }

    public static void placeItem(Level world, BlockPos pos, ItemStack stack) {
        ItemStack newStack = stack.m_41777_();
        stack.m_41764_(0);
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, newStack, 0.0, 0.0, 0.0));
    }

    public static ItemStack tryStoreItemBelow(Level world, BlockPos pos, ItemStack stack) {
        BlockEntity below = world.m_7702_(pos.m_7495_());
        if (below instanceof Container) {
            Container container = (Container)below;
            for (int i = 0; i < container.m_6893_(); ++i) {
                ItemStack containerItem = container.m_8020_(i);
                if (containerItem.m_41619_()) {
                    container.m_6836_(i, stack);
                    return ItemStack.f_41583_;
                }
                if (!ItemStack.m_150942_((ItemStack)containerItem, (ItemStack)stack)) continue;
                int space = containerItem.m_41741_() - containerItem.m_41613_();
                int count = Math.min(stack.m_41613_(), space);
                containerItem.m_41764_(containerItem.m_41613_() + count);
                stack.m_41774_(count);
            }
        }
        return stack;
    }

    public static void exportItem(Level world, BlockPos pos, ItemStack stack, @Nullable Player player) {
        ItemStack remain = Util.tryStoreItemBelow(world, pos, stack);
        if (remain.m_41619_()) {
            return;
        }
        if (player != null) {
            player.m_36356_(remain);
        }
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, remain, 0.0, 0.0, 0.0));
    }
}

