/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MultiFieldCodec<T>
extends MapCodec<T>
implements Iterable<Map.Entry<String, TestedCodec<? extends T>>> {
    private final Map<String, TestedCodec<? extends T>> codecs = new LinkedHashMap<String, TestedCodec<? extends T>>();

    public MultiFieldCodec(Map<String, TestedCodec<? extends T>> codecs) {
        this.codecs.putAll(codecs);
    }

    public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
        return this.codecs.keySet().stream().map(arg_0 -> ops.createString(arg_0));
    }

    public <I> DataResult<T> decode(DynamicOps<I> ops, MapLike<I> input) {
        ArrayList logs = new ArrayList(this.codecs.size());
        for (Map.Entry<String, TestedCodec<T>> entry : this.codecs.entrySet()) {
            String key = entry.getKey();
            TestedCodec adapted = entry.getValue().adapt();
            DataResult result = adapted.decode(ops, input.get(key));
            if (result.isSuccess()) {
                return result.map(Pair::getFirst);
            }
            result.ifError(error -> logs.add(error.messageSupplier()));
        }
        return DataResult.error(() -> MultiCodec.buildMsg(logs));
    }

    public <O> RecordBuilder<O> encode(T input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
        ArrayList logs = new ArrayList(this.codecs.size());
        for (Map.Entry<String, TestedCodec<T>> entry : this.codecs.entrySet()) {
            String key = entry.getKey();
            TestedCodec adapted = entry.getValue().adapt();
            DataResult result = adapted.encodeStart(ops, input);
            if (result.isSuccess()) {
                return prefix.add(key, result);
            }
            result.ifError(error -> logs.add(error.messageSupplier()));
        }
        return prefix.withErrorsFrom(DataResult.error(() -> MultiCodec.buildMsg(logs)));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, TestedCodec<? extends T>>> iterator() {
        return this.codecs.entrySet().iterator();
    }
}

