/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class OptionalMultiFieldCodec<T>
extends MapCodec<Optional<T>>
implements Iterable<Map.Entry<String, TestedCodec<? extends T>>> {
    private final Map<String, TestedCodec<? extends T>> codecs = new LinkedHashMap<String, TestedCodec<? extends T>>();

    public OptionalMultiFieldCodec(Map<String, TestedCodec<? extends T>> codecs) {
        this.codecs.putAll(codecs);
    }

    public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
        return this.codecs.keySet().stream().map(arg_0 -> ops.createString(arg_0));
    }

    public <I> DataResult<Optional<T>> decode(DynamicOps<I> ops, MapLike<I> input) {
        ArrayList logs = new ArrayList(this.codecs.size());
        int skipped = 0;
        for (Map.Entry<String, TestedCodec<T>> entry : this.codecs.entrySet()) {
            String key = entry.getKey();
            if (input.get(key) == null) {
                ++skipped;
                continue;
            }
            TestedCodec adapted = entry.getValue().adapt();
            DataResult result = adapted.decode(ops, input.get(key));
            if (result.isSuccess()) {
                return result.map(pair -> Optional.ofNullable(pair.getFirst()));
            }
            result.ifError(error -> logs.add(error.messageSupplier()));
        }
        return skipped == this.codecs.size() ? DataResult.success(Optional.empty()) : DataResult.error(() -> MultiCodec.buildMsg(logs));
    }

    public <O> RecordBuilder<O> encode(Optional<T> input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
        if (input.isEmpty()) {
            return prefix;
        }
        ArrayList logs = new ArrayList(this.codecs.size());
        for (Map.Entry<String, TestedCodec<T>> entry : this.codecs.entrySet()) {
            String key = entry.getKey();
            TestedCodec adapted = entry.getValue().adapt();
            DataResult result = adapted.encodeStart(ops, input.get());
            if (result.isSuccess()) {
                return prefix.add(key, result);
            }
            result.ifError(error -> logs.add(error.messageSupplier()));
        }
        return prefix.withErrorsFrom(DataResult.error(() -> MultiCodec.buildMsg(logs)));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, TestedCodec<? extends T>>> iterator() {
        return this.codecs.entrySet().iterator();
    }
}

