/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.item.RecipeWizard;
import cool.muyucloud.croparia.api.core.recipe.container.SoakContainer;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.Recipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ElementalStone
extends Block {
    public ElementalStone(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        BlockState infusorState = level.getBlockState(pos.above());
        if (infusorState.getBlock() instanceof Infusor) {
            Element element = (Element)infusorState.getValue(Infusor.ELEMENT);
            for (int i = 0; i < CropariaIf.CONFIG.getSoakAttempts(); ++i) {
                int x = source.nextIntBetweenInclusive(-1, 1);
                int z = source.nextIntBetweenInclusive(-1, 1);
                if (x == 0 && z == 0) {
                    --i;
                    continue;
                }
                this.trySoak(level, pos.offset(x, 0, z), element, source);
            }
        }
    }

    protected void trySoak(ServerLevel level, BlockPos pos, Element element, RandomSource source) {
        BlockState state = level.getBlockState(pos);
        SoakContainer container = new SoakContainer(state, element, source.nextFloat());
        Recipes.SOAK.find(container, (Level)level).ifPresent(recipe -> {
            Vec3 particlePos = pos.getCenter();
            level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, particlePos.x, particlePos.y + 0.5, particlePos.z, 20, 0.5, 0.1, 0.5, 1.0);
            level.playSound(null, pos, SoundEvent.createVariableRangeEvent((ResourceLocation)CropariaIf.of("block.soak.craft")), SoundSource.BLOCKS, 0.5f, 1.0f);
            recipe.getOutput().setBlock(level, pos);
        });
    }

    @NotNull
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof RecipeWizard && player.isCrouching()) {
            level.setBlock(pos.above(), ((Infusor)CropariaBlocks.INFUSOR.get()).defaultBlockState(), 3);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

