/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.item.RecipeWizard;
import cool.muyucloud.croparia.api.core.recipe.InfusorRecipe;
import cool.muyucloud.croparia.api.core.recipe.container.InfusorContainer;
import cool.muyucloud.croparia.api.core.util.DropsCache;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.ItemPlaceable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Infusor
extends Block
implements ItemPlaceable {
    protected final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final EnumProperty<Element> ELEMENT = EnumProperty.create((String)"element", Element.class);

    public Infusor(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ELEMENT, (Comparable)Element.EMPTY));
    }

    @NotNull
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ElementalPotion potion;
        Item item = itemStack.getItem();
        if (item instanceof ElementalPotion && this.tryInfuse(world, pos, potion = (ElementalPotion)item, itemStack, player)) {
            return InteractionResult.SUCCESS;
        }
        Element element = (Element)state.getValue(ELEMENT);
        if (element != Element.EMPTY && ItemStack.isSameItemSameComponents((ItemStack)((ElementalPotion)element.getPotion().get()).getCraftingRemainder(), (ItemStack)itemStack)) {
            return this.tryDefuse(world, pos, itemStack, player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!(item instanceof RecipeWizard) && hand == InteractionHand.MAIN_HAND) {
            this.placeItem(world, pos, itemStack, (Entity)player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean tryInfuse(Level world, BlockPos pos, ElementalPotion potion, @NotNull ItemStack stack, @Nullable Player player) {
        BlockState state = world.getBlockState(pos);
        if (state.getValue(ELEMENT) != Element.EMPTY) {
            return false;
        }
        world.setBlockAndUpdate(pos, (BlockState)((Infusor)CropariaBlocks.INFUSOR.get()).defaultBlockState().setValue(ELEMENT, (Comparable)potion.getElement()));
        world.playSound(null, pos, SoundEvent.createVariableRangeEvent((ResourceLocation)CropariaIf.of("block.infusor.infuse")), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player != null && player.getAbilities().instabuild) {
            return true;
        }
        stack.shrink(1);
        ItemStack returnStack = potion.getCraftingRemainder();
        CifUtil.exportItem(world, pos, returnStack, player);
        return true;
    }

    public boolean tryDefuse(Level world, BlockPos pos, ItemStack stack, @Nullable Player player) {
        Item item = stack.getItem();
        BlockState state = world.getBlockState(pos);
        Element element = (Element)state.getValue(ELEMENT);
        if (element == Element.EMPTY || ElementalPotion.fromElement(element).orElseThrow().getCraftingRemainder().getItem() != item) {
            return false;
        }
        world.setBlockAndUpdate(pos, (BlockState)((Infusor)CropariaBlocks.INFUSOR.get()).defaultBlockState().setValue(ELEMENT, (Comparable)Element.EMPTY));
        if (player != null && !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        ItemStack returnStack = ElementalPotion.fromElement(element).orElseThrow().getDefaultInstance();
        CifUtil.exportItem(world, pos, returnStack, player);
        return true;
    }

    public static Element getElement(BlockState state) {
        return state.getBlock() != CropariaBlocks.INFUSOR.get() ? Element.EMPTY : (Element)state.getValue(ELEMENT);
    }

    public void onCrafting(InfusorRecipe recipe, InfusorContainer container, Level world, BlockPos pos, @Nullable Player player) {
        ItemStack stack = recipe.assemble(container);
        CifUtil.exportItem(world, pos, stack, player);
        world.setBlockAndUpdate(pos, this.defaultBlockState());
        world.playSound(null, pos, SoundEvent.createVariableRangeEvent((ResourceLocation)CropariaIf.of("block.infusor.craft")), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void tryCraft(ServerLevel world, BlockPos pos, ItemStack input, Element element, Player player) {
        if (!CropariaIf.CONFIG.getInfusor().booleanValue()) {
            return;
        }
        if (DropsCache.isTickQueried((Level)world, pos)) {
            return;
        }
        if (element == Element.EMPTY || input.isEmpty()) {
            return;
        }
        InfusorContainer container = InfusorContainer.of(element, DropsCache.queryStacks((Level)world, pos));
        Recipes.INFUSOR.find(container, (Level)world).ifPresent(recipe -> this.onCrafting((InfusorRecipe)recipe, container, (Level)world, pos, player));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        DropsCache.remove(level, pos);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        System.out.println("Infusor triggered by item entity: " + String.valueOf(entity));
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (CropariaIf.CONFIG.getInfusor().booleanValue()) {
                    Player player;
                    ItemStack input = itemEntity.getItem();
                    Element element = (Element)state.getValue(ELEMENT);
                    if (element == Element.EMPTY || input.isEmpty()) {
                        return;
                    }
                    Entity entity2 = itemEntity.getOwner();
                    this.tryCraft(serverWorld, pos, input, element, entity2 instanceof Player ? (player = (Player)entity2) : null);
                }
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ELEMENT});
    }

    @NotNull
    public Item asItem() {
        return (Item)CropariaItems.INFUSOR.get();
    }
}

