/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.item.Croparia;
import cool.muyucloud.croparia.api.crop.util.Color;
import cool.muyucloud.croparia.api.crop.util.CropDependencies;
import cool.muyucloud.croparia.api.crop.util.Material;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import cool.muyucloud.croparia.util.text.Texts;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CreateCommand {
    private static final LiteralArgumentBuilder<CommandSourceStack> CREATE = Commands.literal((String)"create");
    private static final RequiredArgumentBuilder<CommandSourceStack, String> TYPE = RequiredArgumentBuilder.argument((String)"type", (ArgumentType)StringArgumentType.word());
    private static final RequiredArgumentBuilder<CommandSourceStack, String> COLOR = RequiredArgumentBuilder.argument((String)"color", (ArgumentType)StringArgumentType.word());
    private static final RequiredArgumentBuilder<CommandSourceStack, String> NAME = RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.word());
    private static final LiteralArgumentBuilder<CommandSourceStack> REPLACE = LiteralArgumentBuilder.literal((String)"replace");

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return CREATE;
    }

    public static int create(Player player, @Nullable ResourceLocation id, String type, String rawColor, SuccessMessenger success, FailureMessenger failure, boolean client, boolean forced) {
        Color color;
        ItemStack material = player.getMainHandItem();
        if (material.isEmpty()) {
            failure.send((Component)Texts.translatable("commands.croparia.create.no_material", new Object[0]));
            return -1;
        }
        Item rawCroparia = player.getOffhandItem().getItem();
        ResourceLocation resourceLocation = id = id == null ? CropariaIf.of(Objects.requireNonNull(material.getItem().arch$registryName()).getPath()) : id;
        if (id.getNamespace().equals("minecraft")) {
            failure.send((Component)Texts.translatable("commands.croparia.create.namespace", new Object[0]));
            return -1;
        }
        try {
            color = new Color(rawColor);
        }
        catch (NumberFormatException e) {
            failure.send((Component)Texts.translatable("commands.croparia.create.invalid_color", rawColor));
            return -1;
        }
        if (!forced && DgRegistries.CROPS.exists(id)) {
            MutableComponent crop = Texts.literal(id.toString(), new Style[0]);
            crop.withStyle(Texts.runCommand(CommonCommandRoot.commandRoot(client), "crop", id.toString())).withStyle(Texts.inlineMouseBehavior());
            MutableComponent rename = Texts.translatable("commands.croparia.create.duplicated.rename", new Object[0]).withStyle(Texts.suggestCommand(CommonCommandRoot.commandRoot(client), "create", rawColor, type, String.valueOf(id) + "_")).withStyle(Texts.inlineMouseBehavior());
            MutableComponent replace = Texts.translatable("commands.croparia.create.duplicated.replace", new Object[0]).withStyle(Texts.suggestCommand(CommonCommandRoot.commandRoot(client), "create", rawColor, type, id.toString(), "replace")).withStyle(Texts.inlineMouseBehavior());
            MutableComponent duplication = Texts.translatable("commands.croparia.create.duplicated", crop, rename, replace);
            failure.send((Component)duplication);
            return -1;
        }
        if (rawCroparia instanceof Croparia) {
            Croparia croparia = (Croparia)rawCroparia;
            Crop crop = CreateCommand.buildCrop(id, material, color, croparia.getTier(), type);
            Path result = DgRegistries.CROPS.dumpCrop(crop);
            MutableComponent resultComponent = Texts.literal(result.toString(), new Style[0]);
            if (client) {
                resultComponent.withStyle(Texts.openFile(result.toString())).withStyle(Texts.inlineMouseBehavior());
            }
            success.send((Component)Texts.translatable("commands.croparia.create.success", resultComponent), true);
            return croparia.getTier();
        }
        failure.send((Component)Texts.translatable("commands.croparia.create.invalid_croparia", new Object[0]));
        return -1;
    }

    public static Crop buildCrop(ResourceLocation id, ItemStack material, Color color, int tier, String type) {
        return new Crop(id, new Material(material), color, tier, type, null, new CropDependencies(id.getNamespace(), material.getItem().getDescriptionId()));
    }

    static {
        CREATE.requires(s -> s.hasPermission(2));
        COLOR.executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), null, Crop.DEFAULT_TYPE, StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((CommandSourceStack)context.getSource()), Texts.failure((CommandSourceStack)context.getSource()), false, false));
        TYPE.suggests((context, builder) -> {
            for (String type : Crop.PRESET_TYPES) {
                builder.suggest(type);
            }
            return builder.buildFuture();
        }).executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), null, StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((CommandSourceStack)context.getSource()), Texts.failure((CommandSourceStack)context.getSource()), false, false));
        NAME.executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), ResourceLocationArgument.getId((CommandContext)context, (String)"id"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((CommandSourceStack)context.getSource()), Texts.failure((CommandSourceStack)context.getSource()), false, false));
        REPLACE.executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), ResourceLocationArgument.getId((CommandContext)context, (String)"id"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((CommandSourceStack)context.getSource()), Texts.failure((CommandSourceStack)context.getSource()), false, true));
        NAME.then(REPLACE);
        TYPE.then(NAME);
        COLOR.then(TYPE);
        CREATE.then(COLOR);
    }
}

