/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropAccess;
import cool.muyucloud.croparia.api.crop.block.CropariaCropBlock;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CropCommand {
    private static final LiteralArgumentBuilder<CommandSourceStack> CROP = (LiteralArgumentBuilder)Commands.literal((String)"crop").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> Crops.cropSuggestions(builder)).executes(context -> {
        ResourceLocation id = ResourceLocationArgument.getId((CommandContext)context, (String)"id");
        return CropCommand.reportSingular(id, Texts.success((CommandSourceStack)context.getSource()), Texts.failure((CommandSourceStack)context.getSource()));
    }));

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return CROP;
    }

    public static int reportSingular(ResourceLocation id, SuccessMessenger success, FailureMessenger failure) {
        Optional<Crop> crop = DgRegistries.CROPS.forName(id);
        if (crop.isEmpty()) {
            failure.send((Component)Texts.translatable("commands.croparia.crop.absent", id));
            return 0;
        }
        MutableComponent report = CropCommand.buildReport(crop.get());
        success.send((Component)report, false);
        return crop.get().getTier();
    }

    public static int reportForPlayer(Player player, Level world, SuccessMessenger success, FailureMessenger failure) {
        Crop crop = null;
        Item item = player.getWeaponItem().getItem();
        if (item instanceof CropAccess) {
            CropAccess access = (CropAccess)item;
            crop = (Crop)CropAccess.tryGet(access);
        } else {
            item = world.getBlockState(CifUtil.lookingAt(player)).getBlock();
            if (item instanceof CropAccess) {
                CropAccess access = (CropAccess)item;
                crop = (Crop)CropAccess.tryGet(access);
            }
        }
        if (crop == null) {
            failure.send((Component)Texts.translatable("commands.croparia.crop.no_crop", new Object[0]));
            return 0;
        }
        MutableComponent report = CropCommand.buildReport(crop);
        success.send((Component)report, false);
        return crop.getTier();
    }

    public static MutableComponent buildReport(@NotNull Crop crop) {
        MutableComponent name = Texts.translatable("commands.croparia.crop.id", crop.getKey().toString());
        MutableComponent translation = Texts.translatable("commands.croparia.crop.translationKey", Texts.forStyles(Texts.translatable(crop.getTranslationKey(), new Object[0]), Texts.hoverText(crop.getTranslationKey()), Texts.copyText(crop.getTranslationKey())));
        MutableComponent material = Texts.translatable("commands.croparia.crop.material", Texts.literal(crop.getMaterialName(), Texts.suggestCommand("give @s", Objects.requireNonNull(crop.getResult().getItem().arch$registryName()).toString()), Texts.hoverItem(crop.getMaterialStack()), Texts.inlineMouseBehavior()));
        MutableComponent tier = Texts.forStyles(Texts.translatable("commands.croparia.crop.tier", Texts.literal("" + crop.getTier(), Texts.suggestCommand("give @s", CropariaItems.getCroparia(crop.getTier()).getId().toString()), Texts.hoverItem((Item)CropariaItems.getCroparia(crop.getTier()).get()), Texts.inlineMouseBehavior())), new Style[0]);
        MutableComponent color = Texts.translatable("commands.croparia.crop.color", Texts.literal(crop.getColorForm(), Texts.copyText(crop.getColorForm())).withColor(crop.getColor().getValue()));
        MutableComponent type = Texts.translatable("commands.croparia.crop.type", Texts.literal(crop.getType(), Texts.copyText(crop.getType())));
        MutableComponent seed = Texts.translatable("commands.croparia.crop.seed", Texts.literal(crop.getSeedId().toString(), Texts.suggestCommand("give @s", crop.getSeedId().toString()), Texts.hoverItem(crop.getSeedId()), Texts.inlineMouseBehavior()));
        MutableComponent fruit = Texts.translatable("commands.croparia.crop.fruit", Texts.literal(crop.getFruitId().toString(), Texts.suggestCommand("give @s", crop.getFruitId().toString()), Texts.hoverItem(crop.getFruitId()), Texts.inlineMouseBehavior()));
        MutableComponent cropBlock = Texts.translatable("commands.croparia.crop.cropBlock", Texts.literal(crop.getBlockId().toString(), Texts.suggestCommand("setblock ~ ~ ~", String.valueOf(crop.getBlockId()) + "[age=7]"), Texts.hoverText((Component)crop.getCropBlock().map(CropariaCropBlock::getName).orElse(Texts.literal("error", new Style[0]))), Texts.inlineMouseBehavior()));
        MutableComponent status = CropCommand.diagnose(crop);
        return name.append("\n").append((Component)translation).append("\n").append((Component)material).append("\n").append((Component)tier).append("\n").append((Component)color).append("\n").append((Component)type).append("\n").append((Component)seed).append("\n").append((Component)fruit).append("\n").append((Component)cropBlock).append("\n").append((Component)status);
    }

    public static MutableComponent diagnose(@NotNull Crop crop) {
        if (crop.getResult().isEmpty()) {
            return Texts.translatable("commands.croparia.crop.status.material", new Object[0]).withStyle(ChatFormatting.RED);
        }
        if (!crop.shouldLoad()) {
            return Texts.translatable("commands.croparia.crop.status.unavailable", new Object[0]).withStyle(ChatFormatting.YELLOW);
        }
        return Texts.translatable("commands.croparia.crop.status.good", new Object[0]).withStyle(ChatFormatting.GREEN);
    }
}

