/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.component;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockProperties
implements TooltipProvider,
Iterable<Map.Entry<String, String>> {
    public static final Codec<BlockProperties> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(BlockProperties::new, BlockProperties::getProperties);
    public static final StreamCodec<FriendlyByteBuf, BlockProperties> STREAM_CODEC = StreamCodec.of((buf, component) -> buf.writeJsonWithCodec((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), component.getProperties()), buf -> new BlockProperties((Map)buf.readJsonWithCodec((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING))));
    public static final DataComponentType<BlockProperties> TYPE;
    public static final BlockProperties EMPTY;
    public static final Component TITLE;
    private final Map<String, String> properties;

    public static BlockProperties extract(@NotNull BlockState state) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, String> defaults = ((StateHolderAccess)state.getBlock().defaultBlockState()).cif$getProperties();
        StateHolderAccess access = (StateHolderAccess)state;
        for (Map.Entry<String, String> entry : access.cif$getProperties().entrySet()) {
            if (entry.getValue().equals(defaults.get(entry.getKey()))) continue;
            builder.put(entry);
        }
        return BlockProperties.of((Map<String, String>)builder.build());
    }

    public static BlockProperties of(@NotNull BlockState state) {
        return BlockProperties.of(((StateHolderAccess)state).cif$getProperties());
    }

    @NotNull
    public static BlockProperties of(@NotNull Map<String, String> properties) {
        return properties.isEmpty() ? EMPTY : new BlockProperties(properties);
    }

    protected BlockProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        if (this.getProperties().isEmpty()) {
            return;
        }
        consumer.accept(TITLE);
        this.getProperties().forEach((? super K key, ? super V value) -> consumer.accept((Component)Texts.literal("%s=%s".formatted(key, value), new Style[0])));
    }

    public boolean isSubsetOf(BlockState state) {
        StateHolderAccess access = (StateHolderAccess)state;
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            @NotNull String key = entry.getKey();
            @Nullable String value = entry.getValue();
            @Nullable String blockVal = access.cif$getValue(key);
            if (value == null && blockVal != null || Objects.equals(blockVal, value)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockProperties)) {
            return false;
        }
        BlockProperties that = (BlockProperties)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hashCode(this.properties);
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.getProperties().entrySet().iterator();
    }

    static {
        EMPTY = new BlockProperties(Map.of());
        DataComponentType.Builder builder = DataComponentType.builder();
        builder.persistent(CODEC).networkSynchronized(STREAM_CODEC);
        TYPE = builder.build();
        TITLE = Texts.translatable("tooltip.croparia.block_properties", new Object[0]);
    }
}

