/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.entity;

import com.mojang.authlib.GameProfile;
import cool.muyucloud.croparia.CropariaIf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class FakePlayer
extends Player {
    private static final Map<ServerLevel, FakePlayer> FAKE_PLAYERS = new HashMap<ServerLevel, FakePlayer>();
    private static final int MAX_USES = 64;

    public static ArrayList<ItemStack> useAllItemsOn(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull ItemStack item) {
        InteractionResult result;
        ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
        for (int uses = 64; !item.isEmpty() && uses > 0 && (result = FakePlayer.useItemOn(world, pos, item)) != InteractionResult.FAIL && result != InteractionResult.PASS; --uses) {
            ItemStack remainder = FakePlayer.finishUseItem(item, world);
            remainders.add(remainder);
        }
        return remainders;
    }

    public static FakePlayer getPlayer(@NotNull ServerLevel world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.getOrDefault(world, new FakePlayer((Level)world));
        FAKE_PLAYERS.put(world, fakePlayer);
        return fakePlayer;
    }

    public static InteractionResult useItemOn(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull ItemStack item) {
        return FakePlayer.getPlayer(world).useItemOn(pos, item);
    }

    public static ItemStack finishUseItem(@NotNull ItemStack item, @NotNull ServerLevel world) {
        FakePlayer fakePlayer = FakePlayer.getPlayer(world);
        return item.finishUsingItem((Level)world, (LivingEntity)fakePlayer);
    }

    public FakePlayer(@NotNull Level level) {
        super(level, BlockPos.ZERO, 0.0f, new GameProfile(UUID.randomUUID(), "FakePlayer"));
        this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 90.0f);
        CropariaIf.LOGGER.debug("Created fake player for {}", (Object)level.dimension().location());
    }

    public InteractionResult useItemOn(@NotNull BlockPos pos, @NotNull ItemStack item) {
        this.teleportTo(pos.getX(), pos.getY() + 1, pos.getZ());
        BlockHitResult hit = new BlockHitResult(pos.getCenter(), Direction.UP, pos, false);
        this.setItemInHand(InteractionHand.MAIN_HAND, item);
        UseOnContext context = new UseOnContext((Player)this, InteractionHand.MAIN_HAND, hit);
        return item.useOn(context);
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean isCreative() {
        return false;
    }
}

