/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.item.relic;

import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.PostConstants;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import org.jetbrains.annotations.NotNull;

public class HornPlenty
extends Item {
    private static final int MAX_ATTEMPT = 5;

    public HornPlenty(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack food = null;
        int xp = 0;
        for (int i = 0; i < 5; ++i) {
            int index = context.getLevel().random.nextInt(PostConstants.FOODS.size());
            food = PostConstants.FOODS.get(index).getDefaultInstance();
            FoodProperties properties = Objects.requireNonNull(CifUtil.getFoodProperties(food));
            xp = properties.nutrition();
            if (!food.is(PostConstants.HORN_PLENTY_BLACKLIST) && xp <= player.totalExperience) break;
            food = null;
        }
        if (food == null) {
            Texts.overlay(player, (Component)Constants.INSUFFICIENT_XP);
            return InteractionResult.FAIL;
        }
        player.giveExperiencePoints(-xp);
        player.getCooldowns().addCooldown(context.getItemInHand(), 100);
        context.getLevel().addFreshEntity((Entity)new ItemEntity(context.getLevel(), (double)context.getClickedPos().getX() + 0.5, (double)context.getClickedPos().getY() + 1.0, (double)context.getClickedPos().getZ() + 0.5, food));
        return InteractionResult.SUCCESS;
    }
}

