/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.item.relic;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.component.TargetPos;
import cool.muyucloud.croparia.registry.CropariaComponents;
import cool.muyucloud.croparia.util.text.Texts;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicRope
extends Item {
    public MagicRope(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ServerPlayer player;
        Player player2;
        Level level = context.getLevel();
        if (!level.isClientSide && (player2 = context.getPlayer()) instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null) {
            MinecraftServer server = player.getServer();
            ItemStack itemStack = context.getItemInHand();
            if (player.isShiftKeyDown()) {
                TargetPos targetPos = new TargetPos((Entity)player);
                itemStack.set((DataComponentType)CropariaComponents.TARGET_POS.get(), (Object)targetPos);
                Texts.overlay((Player)player, (Component)targetPos.getTooltip());
                return InteractionResult.SUCCESS;
            }
            @Nullable TargetPos targetPos = (TargetPos)itemStack.get((DataComponentType)CropariaComponents.TARGET_POS.get());
            if (targetPos == null) {
                Texts.overlay((Player)player, (Component)Texts.translatable("overlay.croparia.magic_rope.no_target", new Object[0]));
                return InteractionResult.FAIL;
            }
            level.playSound(null, player.getOnPos(), SoundEvent.createVariableRangeEvent((ResourceLocation)CropariaIf.of("ambient.magic_rope.teleport")), SoundSource.AMBIENT, 1.0f, 1.0f);
            targetPos.teleport((Entity)player, server);
            targetPos.getLevel(server).ifPresent(targetLevel -> targetLevel.playSound(null, targetPos.getPos(), SoundEvent.createVariableRangeEvent((ResourceLocation)CropariaIf.of("ambient.magic_rope.teleport")), SoundSource.AMBIENT, 1.0f, 1.0f));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

