/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.recipe.container.SoakContainer;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.ElementAccess;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.entry.BlockOutput;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.Mappable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SoakRecipe
implements DisplayableRecipe<SoakContainer> {
    public static final TypedSerializer<SoakRecipe> TYPED_SERIALIZER = new TypedSerializer<SoakRecipe>(CropariaIf.of("soak"), SoakRecipe.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)ElementAccess.CODEC.fieldOf("element").forGetter(SoakRecipe::getElement), (App)Codec.FLOAT.fieldOf("probability").forGetter(SoakRecipe::getProbability), (App)BlockInput.CODEC.fieldOf("input").forGetter(SoakRecipe::getInput), (App)BlockOutput.CODEC.fieldOf("output").forGetter(SoakRecipe::getOutput)).apply((Applicative)instance, SoakRecipe::new)), TypedSerializer.JEI, Mappable.of(CropariaItems.ELEMENTAL_STONE, Item::getDefaultInstance));
    private final Element element;
    private final float probability;
    private final BlockInput input;
    private final BlockOutput output;

    public SoakRecipe(Element element, float probability, BlockInput input, BlockOutput output) {
        if (element == Element.EMPTY) {
            throw new IllegalArgumentException("Element cannot be EMPTY");
        }
        this.element = element;
        this.probability = probability;
        this.input = input;
        this.output = output;
        this.input.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.SOAK_BLOCK_INPUT));
            return stacks;
        });
    }

    public Element getElement() {
        return this.element;
    }

    public ItemStack getPotion() {
        return Texts.tooltip(((ElementalPotion)this.getElement().getPotion().get()).getDefaultInstance(), Constants.ELEM_INFUSE_TOOLTIP);
    }

    public float getProbability() {
        return this.probability;
    }

    public BlockInput getInput() {
        return this.input;
    }

    public BlockOutput getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        return List.of(this.getInput().getDisplayStacks(), List.of(this.getPotion()));
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getOutputs() {
        return List.of(List.of(this.getOutput().getDisplayStack()));
    }

    public boolean matches(SoakContainer input, Level level) {
        return this.getInput().matches(input.getState()) && this.getElement() == input.getElement() && input.getRandom() < this.getProbability();
    }

    @Override
    public TypedSerializer<SoakRecipe> getTypedSerializer() {
        return TYPED_SERIALIZER;
    }

    @Deprecated
    @NotNull
    public ItemStack assemble(SoakContainer recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public SlotDisplay result() {
        return this.getOutput();
    }

    @Override
    @NotNull
    public SlotDisplay craftingStation() {
        return new SlotDisplay.ItemStackSlotDisplay((ItemStack)this.getTypedSerializer().getStations().getFirst().get());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SoakRecipe)) {
            return false;
        }
        SoakRecipe that = (SoakRecipe)o;
        return Float.compare(this.probability, that.probability) == 0 && Objects.equals(this.element, that.element) && Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.element, Float.valueOf(this.probability), this.input, this.output);
    }
}

