/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.crop.AbstractCrop;
import cool.muyucloud.croparia.api.crop.block.CropariaCropBlock;
import cool.muyucloud.croparia.api.crop.item.CropFruit;
import cool.muyucloud.croparia.api.crop.item.CropSeed;
import cool.muyucloud.croparia.api.crop.util.Color;
import cool.muyucloud.croparia.api.crop.util.CropDependencies;
import cool.muyucloud.croparia.api.crop.util.Material;
import cool.muyucloud.croparia.api.crop.util.TierAccess;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.supplier.HolderSupplier;
import cool.muyucloud.croparia.util.supplier.LazySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Crop
extends AbstractCrop
implements TierAccess {
    public static final Set<String> PRESET_TYPES = new HashSet<String>();
    public static final String ANIMAL = Crop.addType("animal");
    public static final String CROP = Crop.addType("crop");
    public static final String FOOD = Crop.addType("food");
    public static final String MONSTER = Crop.addType("monster");
    public static final String NATURE = Crop.addType("nature");
    public static final String DEFAULT_TYPE = CROP;
    public static final MapCodec<Crop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.fieldsOf(ResourceLocation.CODEC, "id", "name").forGetter(Crop::getKey), (App)CodecUtil.fieldsOf(Material.CODEC, "material", "tag").forGetter(Crop::getMaterial), (App)Color.CODEC.fieldOf("color").forGetter(Crop::getColor), (App)Codec.INT.fieldOf("tier").forGetter(Crop::getTier), (App)Codec.STRING.optionalFieldOf("type", (Object)"crop").forGetter(Crop::getType), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("translations").forGetter(Crop::getTranslationsOptional), (App)CropDependencies.CODEC_ANY.optionalFieldOf("dependencies", CropDependencies.EMPTY).forGetter(Crop::getDependencies)).apply((Applicative)instance, (name, material, color, tier, type, translations, dependencies) -> new Crop((ResourceLocation)name, (Material)material, (Color)color, (int)tier, (String)type, translations.orElse(null), (CropDependencies)dependencies)));
    public static final Placeholder<Crop> PLACEHOLDER = Placeholder.build(node -> node.then(PatternKey.literal("color"), TypeMapper.of(Crop::getColor), Color.PLACEHOLDER).then(PatternKey.literal("type"), TypeMapper.of(Crop::getType), Placeholder.STRING).then(PatternKey.literal("tier"), TypeMapper.of(Crop::getTier), Placeholder.NUMBER).then(PatternKey.literal("seed"), TypeMapper.of(Crop::getSeedId), Placeholder.ID).then(PatternKey.literal("fruit"), TypeMapper.of(Crop::getFruitId), Placeholder.ID).then(PatternKey.literal("crop_block"), TypeMapper.of(Crop::getBlockId), Placeholder.ID).then(PatternKey.literal("croparia"), TypeMapper.of(crop -> CropariaItems.getCroparia(crop.getTier()).getId()), Placeholder.ID).concat(AbstractCrop.PLACEHOLDER, TypeMapper.of(crop -> crop)));
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final Material material;
    @NotNull
    private final Color color;
    private final int tier;
    @NotNull
    private final String type;
    @NotNull
    private final ImmutableMap<String, String> translations;
    @NotNull
    private final CropDependencies dependencies;
    @NotNull
    private final transient HolderSupplier<CropariaCropBlock> block;
    @NotNull
    private final transient HolderSupplier<CropSeed> seed;
    @NotNull
    private final transient HolderSupplier<CropFruit> fruit;
    private final transient String defaultTranslation;
    private final transient String defaultTranslationKey;
    private final transient LazySupplier<Boolean> load = LazySupplier.of(() -> this.getDependencies().shouldLoad() && CropariaIf.CONFIG.isCropValid(this.getKey()));

    public static String addType(String type) {
        PRESET_TYPES.add(type);
        return type;
    }

    public static String defaultTranslation(ResourceLocation id) {
        String name = id.getPath();
        name = name.replaceAll("_", " ").trim();
        StringBuilder builder = new StringBuilder();
        for (String token : name.split(" ")) {
            builder.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1)).append(" ");
        }
        return builder.toString().trim();
    }

    public static String defaultTranslationKey(ResourceLocation id) {
        return "crop.%s.%s".formatted(id.getNamespace(), id.getPath());
    }

    public Crop(@NotNull ResourceLocation id, @NotNull Material material, @NotNull Color color, int tier, @Nullable String type, @Nullable Map<String, String> translations, @NotNull CropDependencies dependencies) {
        this.id = id;
        this.material = material;
        this.color = color;
        this.tier = tier;
        this.defaultTranslationKey = Crop.defaultTranslationKey(id);
        this.dependencies = dependencies.isEmpty() ? new CropDependencies("croparia", this.getDefaultTranslationKey()) : dependencies;
        this.defaultTranslation = Crop.defaultTranslation(id);
        HashMap<String, String> builder = new HashMap<String, String>();
        builder.put("en_us", this.getDefaultTranslation());
        builder.putAll(translations == null ? Collections.emptyMap() : translations);
        this.translations = ImmutableMap.copyOf(builder);
        this.type = type == null ? DEFAULT_TYPE : type;
        this.block = HolderSupplier.of(() -> new CropariaCropBlock(this), CifUtil.formatId("block_crop_%s", this.getKey()), Registries.BLOCK);
        this.seed = HolderSupplier.of(() -> new CropSeed(this), CifUtil.formatId("crop_seed_%s", this.getKey()), Registries.ITEM);
        this.fruit = HolderSupplier.of(() -> new CropFruit(this), CifUtil.formatId("fruit_%s", this.getKey()), Registries.ITEM);
        this.results = this.results.map(stacks -> stacks.stream().filter(stack -> CropariaIf.CONFIG.isModValid(Objects.requireNonNull(stack.getItem().arch$registryName()).getNamespace())).toList());
    }

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.id;
    }

    @Override
    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public DataComponentPatch getPatch() {
        return this.getMaterial().getComponents();
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    public int getColorInt() {
        return this.getColor().getValue();
    }

    public String getColorDec() {
        return this.getColor().toDecString();
    }

    public String getColorHex() {
        return this.getColor().toHexString();
    }

    public String getColorForm() {
        return this.getColor().toString();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public Collection<String> getLangs() {
        return this.getTranslations().keySet();
    }

    @Override
    @NotNull
    public String getTranslationKey() {
        return this.dependencies.getChosen();
    }

    public Optional<String> getTranslationKeyOptional() {
        if (this.getTranslationKey().equals(this.defaultTranslationKey)) {
            return Optional.empty();
        }
        return Optional.of(this.getTranslationKey());
    }

    @NotNull
    public ImmutableMap<String, String> getTranslations() {
        return this.translations;
    }

    @Override
    @Nullable
    public String translate(String lang) {
        return (String)this.getTranslations().get((Object)lang);
    }

    public Optional<Map<String, String>> getTranslationsOptional() {
        ImmutableMap<String, String> translations = this.getTranslations();
        if (translations.size() == 1 && translations.containsValue(this.getDefaultTranslation())) {
            return Optional.empty();
        }
        return Optional.of(translations);
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public Optional<String> getTypeOptional() {
        return this.getType().equals(DEFAULT_TYPE) ? Optional.empty() : Optional.of(this.getType());
    }

    @NotNull
    public CropDependencies getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public ResourceLocation getBlockId() {
        return this.block.getId();
    }

    public Optional<CropariaCropBlock> getCropBlock() {
        return this.block.toOptional();
    }

    @NotNull
    public ResourceLocation getSeedId() {
        return this.seed.getId();
    }

    public Optional<CropSeed> getCropSeed() {
        return this.seed.toOptional();
    }

    @NotNull
    public ResourceLocation getFruitId() {
        return this.fruit.getId();
    }

    public Optional<CropFruit> getCropFruit() {
        return this.fruit.toOptional();
    }

    public String getDefaultTranslation() {
        return this.defaultTranslation;
    }

    public String getDefaultTranslationKey() {
        return this.defaultTranslationKey;
    }

    public Placeholder<? extends Crop> placeholder() {
        return PLACEHOLDER;
    }

    @Override
    public boolean shouldLoad() {
        return this.load.get();
    }

    @Override
    public void onRegister() {
        this.block.tryRegister();
        this.seed.tryRegister();
        this.fruit.tryRegister();
    }
}

