/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.element.item;

import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.ElementAccess;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ElementalGem
extends Item
implements ElementAccess {
    private static final Map<Element, ElementalGem> ELEMATILIUS_MAP = new HashMap<Element, ElementalGem>();
    @NotNull
    private final Element element;

    public ElementalGem(@NotNull Element element, @NotNull Item.Properties properties) {
        super(properties);
        this.element = this.assertEmpty(element);
        ELEMATILIUS_MAP.put(element, this);
    }

    @Override
    @NotNull
    public Element getElement() {
        return this.element;
    }

    public static Optional<ElementalGem> getElement(@NotNull Element element) {
        return Optional.ofNullable(ELEMATILIUS_MAP.get(element));
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        MutableComponent elemName = Texts.translatable(this.getElement().getTranslationKey(), new Object[0]);
        return Texts.translatable("item.croparia.element.gem", elemName);
    }
}

