/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.element.item;

import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.ElementAccess;
import cool.muyucloud.croparia.util.ItemPlaceable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ElementalPotion
extends Item
implements ElementAccess {
    private static final Map<Element, ElementalPotion> POTIONS = new HashMap<Element, ElementalPotion>();
    private final Element element;

    public ElementalPotion(@NotNull Element element, @NotNull Item.Properties properties) {
        super(properties);
        if (element == Element.EMPTY) {
            throw new IllegalArgumentException("ElementalPotion cannot be empty element");
        }
        this.element = element;
        POTIONS.put(element, this);
        DispenserBlock.registerBehavior((ItemLike)this, (blockSource, itemStack) -> {
            BlockState sourceState;
            Direction direction;
            BlockPos sourcePos;
            BlockPos targetPos;
            ServerLevel world = blockSource.level();
            BlockState targetState = world.getBlockState(targetPos = (sourcePos = blockSource.pos()).offset((direction = (Direction)(sourceState = blockSource.state()).getValue((Property)DispenserBlock.FACING)).getUnitVec3i()));
            Block targetBlock = targetState.getBlock();
            if (targetBlock instanceof Infusor) {
                Infusor infusor = (Infusor)targetBlock;
                if (!infusor.tryInfuse((Level)world, targetPos, this, itemStack, null)) {
                    infusor.placeItem((Level)world, targetPos, itemStack.split(1), null);
                }
            } else if (targetBlock instanceof ItemPlaceable) {
                ItemPlaceable placeable = (ItemPlaceable)targetBlock;
                placeable.placeItem((Level)world, targetPos, itemStack.split(1), null);
            } else {
                DefaultDispenseItemBehavior.spawnItem((Level)world, (ItemStack)itemStack.split(1), (int)1, (Direction)direction, (Position)targetPos.getCenter());
            }
            return itemStack;
        });
    }

    @Override
    @NotNull
    public Element getElement() {
        return this.element;
    }

    public static Optional<ElementalPotion> fromElement(Element element) {
        return Optional.ofNullable(POTIONS.get(element));
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        MutableComponent elemName = Texts.translatable(this.getElement().getTranslationKey(), new Object[0]);
        return Texts.translatable("item.croparia.element.potion", elemName);
    }
}

