/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import cool.muyucloud.croparia.api.generator.DataGenerator;
import cool.muyucloud.croparia.api.generator.util.CdgFormatException;
import cool.muyucloud.croparia.api.json.JsonTransformer;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class DgReader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonObject read(File file) throws IOException, JsonParseException {
        JsonElement json = JsonTransformer.transform(file);
        if (json.isJsonObject()) {
            return json.getAsJsonObject();
        }
        throw new JsonParseException("Expecting JsonObject in " + file.getAbsolutePath());
    }

    public static JsonObject tryRead(String source) {
        try {
            return DgReader.read(source);
        }
        catch (CdgFormatException e) {
            DataGenerator.LOGGER.error("Failed to read CDG source: " + e.getMessage(), (Throwable)((Object)e));
            return new JsonObject();
        }
    }

    public static JsonObject read(String source) throws CdgFormatException {
        if (source == null) {
            source = "";
        }
        int len = source.length();
        int i = 0;
        JsonObject root = new JsonObject();
        if (source.startsWith("\ufeff")) {
            ++i;
        }
        while ((i = DgReader.skipWhitespace(source, i)) < len) {
            char kc;
            char c = source.charAt(i);
            if (c != '@') {
                String template = source.substring(i).trim();
                if (!template.isEmpty()) {
                    root.addProperty("template", template);
                }
                return root;
            }
            int keyStart = ++i;
            while (i < len && (kc = source.charAt(i)) != '=' && !Character.isWhitespace(kc)) {
                ++i;
            }
            String key = source.substring(keyStart, i).trim();
            if (key.isEmpty()) {
                throw DgReader.syntax("Expecting @meta=...", source, i);
            }
            if ((i = DgReader.skipWhitespace(source, i)) >= len || source.charAt(i) != '=') {
                throw DgReader.syntax("Expecting '='", source, i);
            }
            ++i;
            if ((i = DgReader.skipWhitespace(source, i)) >= len) {
                throw DgReader.syntax("Expecting value", source, i);
            }
            ParseResult val = DgReader.readValueUntilSemicolon(source, i);
            i = val.nextIndex;
            if ((i = DgReader.skipWhitespace(source, i)) >= len || source.charAt(i) != ';') {
                throw DgReader.syntax("Expecting ';'", source, i);
            }
            ++i;
            root.add(key, DgReader.toJsonElement(val.value, val.kind));
        }
        return root;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonElement toJsonElement(String raw, ValueKind kind) {
        switch (kind.ordinal()) {
            case 0: 
            case 1: {
                return new JsonPrimitive(raw);
            }
            case 2: {
                return (JsonElement)DgReader.GSON.fromJson(raw, JsonElement.class);
            }
            case 3: {
                ** GOTO lbl14
            }
            default: {
                return new JsonPrimitive(raw);
            }
        }
        {
            catch (JsonSyntaxException var2_3) {
                // empty catch block
                return new JsonPrimitive(raw);
            }
lbl14:
            // 1 sources

            try {
                return (JsonElement)DgReader.GSON.fromJson(raw, JsonElement.class);
            }
            catch (JsonSyntaxException ex) {}
            return new JsonPrimitive(raw);
        }
    }

    private static ParseResult readValueUntilSemicolon(String s, int i) throws CdgFormatException {
        int len = s.length();
        if (i >= len) {
            return new ParseResult("", ValueKind.STRING, i);
        }
        if (DgReader.peekTripleQuote(s, i)) {
            int start = i + 3;
            int end = DgReader.indexOfTripleQuote(s, start);
            if (end < 0) {
                throw DgReader.syntax("Unclosed triple-quoted string (''')", s, i);
            }
            String content = s.substring(start, end);
            return new ParseResult(content, ValueKind.MULTILINE, end + 3);
        }
        char ch = s.charAt(i);
        if (ch == '\"' || ch == '\'') {
            boolean isDouble = ch == '\"';
            StringBuilder out = new StringBuilder();
            int j = i + 1;
            while (j < len) {
                char c;
                if ((c = s.charAt(j++)) == '\\') {
                    if (j >= len) break;
                    char e = s.charAt(j++);
                    switch (e) {
                        case 'n': {
                            out.append('\n');
                            break;
                        }
                        case 'r': {
                            out.append('\r');
                            break;
                        }
                        case 't': {
                            out.append('\t');
                            break;
                        }
                        case 'b': {
                            out.append('\b');
                            break;
                        }
                        case 'f': {
                            out.append('\f');
                            break;
                        }
                        case '\\': {
                            out.append('\\');
                            break;
                        }
                        case '\'': {
                            out.append('\'');
                            break;
                        }
                        case '\"': {
                            out.append('\"');
                            break;
                        }
                        case 'u': {
                            if (j + 3 < len) {
                                String hex = s.substring(j, j + 4);
                                try {
                                    out.append((char)Integer.parseInt(hex, 16));
                                    j += 4;
                                }
                                catch (NumberFormatException nfe) {
                                    out.append("\\u").append(hex);
                                    j += 4;
                                }
                                break;
                            }
                            out.append("\\u");
                            break;
                        }
                        default: {
                            out.append(e);
                        }
                    }
                    continue;
                }
                if (c == (isDouble ? (char)'\"' : '\'')) {
                    return new ParseResult(out.toString(), ValueKind.STRING, j);
                }
                out.append(c);
            }
            throw DgReader.syntax("Unclosed quotes", s, i);
        }
        int j = i;
        int brace = 0;
        int bracket = 0;
        boolean inStr = false;
        char strQuote = '\u0000';
        boolean escape = false;
        block22: while (j < len) {
            char c = s.charAt(j);
            if (inStr) {
                if (escape) {
                    escape = false;
                } else if (c == '\\') {
                    escape = true;
                } else if (c == strQuote) {
                    inStr = false;
                }
                ++j;
                continue;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    inStr = true;
                    strQuote = c;
                    ++j;
                    continue block22;
                }
                case '{': {
                    ++brace;
                    ++j;
                    continue block22;
                }
                case '}': {
                    if (brace > 0) {
                        --brace;
                    }
                    ++j;
                    continue block22;
                }
                case '[': {
                    ++bracket;
                    ++j;
                    continue block22;
                }
                case ']': {
                    if (bracket > 0) {
                        --bracket;
                    }
                    ++j;
                    continue block22;
                }
                case ';': {
                    if (brace == 0 && bracket == 0) {
                        String raw = s.substring(i, j).trim();
                        ValueKind kind = DgReader.guessKind(raw);
                        return new ParseResult(raw, kind, j);
                    }
                    ++j;
                    continue block22;
                }
            }
            ++j;
        }
        throw DgReader.syntax("Semicolon ';' not found ", s, i);
    }

    private static ValueKind guessKind(String raw) {
        if (raw.isEmpty()) {
            return ValueKind.STRING;
        }
        char f = raw.charAt(0);
        if (f == '{' || f == '[' || f == '\"') {
            return ValueKind.JSON;
        }
        if (f == '-' || f >= '0' && f <= '9' || f == 't' || f == 'f' || f == 'n') {
            return ValueKind.AMBIGUOUS;
        }
        return ValueKind.STRING;
    }

    private static boolean peekTripleQuote(String s, int i) {
        return i + 2 < s.length() && s.charAt(i) == '\'' && s.charAt(i + 1) == '\'' && s.charAt(i + 2) == '\'';
    }

    private static int indexOfTripleQuote(String s, int from) {
        int i = s.indexOf("'''", from);
        if (i < 0) {
            return -1;
        }
        return i;
    }

    private static int skipWhitespace(String s, int i) {
        char c;
        int len = s.length();
        while (i < len && Character.isWhitespace(c = s.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static CdgFormatException syntax(String msg, String src, int pos) {
        int start = Math.max(0, pos - 20);
        int end = Math.min(src.length(), pos + 20);
        String ctx = src.substring(start, end).replace("\n", "\\n");
        return new CdgFormatException(msg + ", at=" + pos + ", context: ..." + ctx + "...");
    }

    private static class ParseResult {
        final String value;
        final ValueKind kind;
        final int nextIndex;

        ParseResult(String v, ValueKind k, int n) {
            this.value = Objects.requireNonNull(v);
            this.kind = Objects.requireNonNull(k);
            this.nextIndex = n;
        }
    }

    private static enum ValueKind {
        STRING,
        MULTILINE,
        JSON,
        AMBIGUOUS;

    }
}

