/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator.util;

import cool.muyucloud.croparia.api.generator.DataGenerator;
import cool.muyucloud.croparia.api.generator.util.PackCacheEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PackCache {
    private final Map<String, PackCacheEntry<?>> byPath = new HashMap();
    private final Map<DataGenerator, Set<PackCacheEntry<?>>> byGenerator = new HashMap();

    public void clear() {
        this.byPath.clear();
        this.byGenerator.clear();
    }

    public <T> T cache(String path, T value, DataGenerator owner) {
        PackCacheEntry<Object> entry = this.byPath.get(path);
        if (entry != null) {
            this.byGenerator.computeIfAbsent(entry.owner(), k -> new HashSet()).remove(entry);
        }
        entry = new PackCacheEntry<T>(owner, path, value);
        this.byGenerator.computeIfAbsent(owner, k -> new HashSet()).add(entry);
        this.byPath.put(path, entry);
        return value;
    }

    public <T> Optional<T> occupy(DataGenerator querier, String path) throws ClassCastException {
        PackCacheEntry<?> entry = this.byPath.get(path);
        if (entry == null) {
            return Optional.empty();
        }
        Object value = entry.value();
        if (entry.owner() != querier) {
            this.cache(path, value, querier);
        }
        return Optional.ofNullable(value);
    }

    public <T> Optional<T> query(DataGenerator querier, String path) throws ClassCastException {
        PackCacheEntry<?> entry = this.byPath.get(path);
        if (entry == null) {
            return Optional.empty();
        }
        Object value = entry.value();
        if (entry.owner() != querier) {
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    public Set<PackCacheEntry<?>> getAll(DataGenerator querier) {
        return this.byGenerator.computeIfAbsent(querier, k -> new HashSet());
    }

    public Collection<PackCacheEntry<?>> entries() {
        return Collections.unmodifiableCollection(this.byPath.values());
    }
}

