/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.json.JsonBuilder;
import java.util.Map;
import java.util.function.Supplier;

public class MapBuilder
implements JsonBuilder {
    private final JsonObject json = new JsonObject();

    public MapBuilder(Object ... entries) {
        for (int i = 0; i < entries.length; i += 2) {
            this.json.add((String)entries[i], JsonBuilder.parse(entries[i + 1]));
        }
    }

    public MapBuilder(Map<String, Object> map) {
        this.with(map);
    }

    public JsonObject build() {
        return this.json;
    }

    public MapBuilder with(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.json.add(entry.getKey(), JsonBuilder.parse(entry.getValue()));
        }
        return this;
    }

    public MapBuilder with(String key, JsonElement value) {
        this.json.add(key, value);
        return this;
    }

    public MapBuilder with(String key, JsonBuilder builder) {
        return this.with(key, builder.build());
    }

    public MapBuilder with(String key, Number value) {
        this.json.addProperty(key, value);
        return this;
    }

    public MapBuilder with(String key, String value) {
        this.json.addProperty(key, value);
        return this;
    }

    public MapBuilder with(String key, boolean value) {
        this.json.addProperty(key, Boolean.valueOf(value));
        return this;
    }

    public MapBuilder with(String key, Character value) {
        this.json.addProperty(key, value);
        return this;
    }

    public <T> DataResult<Pair<JsonElement, MapBuilder>> with(String key, T value, Codec<T> codec) {
        return (DataResult)CodecUtil.encodeJson(value, codec).mapOrElse(json -> DataResult.success((Object)Pair.of((Object)json, (Object)this)), err -> DataResult.error((Supplier)err.messageSupplier()));
    }
}

