/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.network;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.network.NetworkHandlerType;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public interface NetworkHandler
extends CustomPacketPayload {
    @NotNull
    default public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return this.handlerType().type();
    }

    default public void send() {
        CropariaIf.ifServerOrElse(server -> {
            if (this.handlerType().side() == NetworkManager.Side.S2C) {
                NetworkManager.sendToPlayers((Iterable)server.getPlayerList().getPlayers(), (CustomPacketPayload)this);
            }
        }, () -> {
            if (this.handlerType().side() == NetworkManager.Side.C2S) {
                NetworkManager.sendToServer((CustomPacketPayload)this);
            }
        });
    }

    default public void send(ServerPlayer player) {
        if (this.handlerType().side() == NetworkManager.Side.S2C) {
            CropariaIf.ifServer(server -> NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this));
        }
    }

    default public void send(Iterable<ServerPlayer> players) {
        if (this.handlerType().side() == NetworkManager.Side.S2C) {
            CropariaIf.ifServer(server -> NetworkManager.sendToPlayers((Iterable)players, (CustomPacketPayload)this));
        }
    }

    @NotNull
    public NetworkHandlerType<?> handlerType();

    public void handle(NetworkManager.PacketContext var1);
}

