/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.PlaceholderException;
import java.util.regex.Matcher;

public interface PlaceholderAccess {
    public static <T> Direct<T> of(T value, Placeholder<T> placeholder) {
        return new Direct<T>(value, placeholder);
    }

    public Placeholder<?> placeholder();

    default public String parsePlaceholder(String placeholder, Matcher matcher) throws PlaceholderException {
        try {
            return this.placeholder().parseStart(this, placeholder, matcher);
        }
        catch (ClassCastException e) {
            throw new PlaceholderException(e);
        }
    }

    public static class Direct<T>
    implements PlaceholderAccess {
        private final T value;
        private final Placeholder<T> placeholder;

        private Direct(T value, Placeholder<T> placeholder) {
            this.value = value;
            this.placeholder = placeholder;
        }

        public Placeholder<T> placeholder() {
            return this.placeholder;
        }

        @Override
        public String parsePlaceholder(String placeholder, Matcher matcher) throws PlaceholderException {
            try {
                return this.placeholder().parseStart(this.value, placeholder, matcher);
            }
            catch (ClassCastException e) {
                throw new PlaceholderException(e);
            }
        }
    }
}

