/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.PlaceholderAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;

public class Template {
    public static final Codec<Template> CODEC = Codec.STRING.xmap(Template::new, Template::getTemplate);
    private final String template;
    private final List<Span> spans = new ArrayList<Span>();

    public Template(String template) {
        this.template = template;
        this.read(template);
    }

    public String getTemplate() {
        return this.template;
    }

    public void read(String template) {
        this.spans.clear();
        boolean escape = false;
        boolean inSpan = false;
        int spanStart = -1;
        int depth = 0;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (escape) {
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (!inSpan) {
                if (c != '$' || i + 1 >= template.length() || template.charAt(i + 1) != '{') continue;
                inSpan = true;
                spanStart = i++;
                depth = 1;
                continue;
            }
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            int spanEnd = i + 1;
            String content = template.substring(spanStart, spanEnd);
            this.spans.add(new Span(spanStart, spanEnd, content));
            inSpan = false;
            spanStart = -1;
        }
        if (inSpan) {
            throw new JsonParseException("Unclosed placeholder in template: " + template);
        }
    }

    public <T> String parse(T entry, Placeholder<T> placeholder) {
        return this.parse(entry, placeholder, Function.identity());
    }

    public String parse(PlaceholderAccess entry) {
        return this.parse(entry, entry.placeholder(), Function.identity());
    }

    public <T> String parse(T entry, Placeholder<T> placeholder, Function<String, String> preProcess) {
        HashMap<String, String> cache = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder(this.template.length());
        int cursor = 0;
        for (Span span : this.spans) {
            String content = preProcess.apply(span.getContent());
            Matcher m = PatternKey.PLACEHOLDER.matcher(content);
            if (!m.matches()) {
                throw new JsonParseException("Invalid placeholder format: %s (%s)".formatted(span.getContent(), content));
            }
            String parsed = cache.computeIfAbsent(content, key -> placeholder.parseStart(entry, m.group(1), m));
            sb.append(this.template, cursor, span.getStart());
            sb.append(parsed);
            cursor = span.getEnd();
        }
        sb.append(this.template, cursor, this.template.length());
        return sb.toString();
    }

    public static class Span {
        private final int start;
        private final int end;
        private final String content;

        public Span(int start, int end, String content) {
            this.start = start;
            this.end = end;
            this.content = content;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getContent() {
            return this.content;
        }
    }
}

