/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe;

import com.mojang.logging.LogUtils;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public interface DisplayableRecipe<C extends RecipeInput>
extends Recipe<C>,
RecipeDisplay {
    public static final Logger LOGGER = LogUtils.getLogger();

    public TypedSerializer<? extends DisplayableRecipe<C>> getTypedSerializer();

    @NotNull
    default public List<List<ItemStack>> getInputs() {
        return List.of();
    }

    @NotNull
    default public List<List<ItemStack>> getOutputs() {
        return List.of();
    }

    @NotNull
    default public TypedSerializer<? extends DisplayableRecipe<C>> getType() {
        return this.getTypedSerializer();
    }

    @NotNull
    default public TypedSerializer<? extends DisplayableRecipe<C>> getSerializer() {
        return this.getTypedSerializer();
    }

    @NotNull
    default public TypedSerializer<? extends DisplayableRecipe<C>> recipeBookCategory() {
        return this.getTypedSerializer();
    }

    @NotNull
    default public PlacementInfo placementInfo() {
        if (this.getInputs().isEmpty()) {
            return PlacementInfo.NOT_PLACEABLE;
        }
        return PlacementInfo.create(this.getInputs().stream().map(slot -> Ingredient.of(slot.stream().map(ItemStack::getItem))).toList());
    }

    default public boolean isSpecial() {
        return false;
    }

    @NotNull
    default public SlotDisplay result() {
        return SlotDisplay.Empty.INSTANCE;
    }

    @NotNull
    default public SlotDisplay craftingStation() {
        return SlotDisplay.Empty.INSTANCE;
    }

    @NotNull
    default public List<RecipeDisplay> display() {
        return List.of(this);
    }

    @NotNull
    default public RecipeDisplay.Type<? extends DisplayableRecipe<?>> type() {
        return this.getTypedSerializer().displayType();
    }

    default public <T extends RecipeInput, R extends Recipe<T>> R adapt() {
        return (R)this;
    }
}

