/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.core.block.Placeholder;
import cool.muyucloud.croparia.api.core.component.BlockProperties;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.TagUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class BlockInput
implements SlotDisplay {
    public static final ItemStack STACK_UNKNOWN = Items.BEDROCK.getDefaultInstance();
    public static final ItemStack STACK_AIR = Items.BARRIER.getDefaultInstance();
    public static final ItemStack STACK_ANY = Items.LIGHT_GRAY_STAINED_GLASS_PANE.getDefaultInstance();
    public static final Supplier<ItemStack> STACK_PLACEHOLDER = () -> ((BlockItem)CropariaItems.PLACEHOLDER_BLOCK.get()).getDefaultInstance();
    public static final BlockInput UNKNOWN = BlockInput.of(CropariaIf.of("unknown"));
    public static final BlockInput ANY = new BlockInput(null, null, BlockProperties.EMPTY);
    public static final MapCodec<BlockInput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("id").forGetter(BlockInput::getId), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("tag").forGetter(BlockInput::getTag), (App)BlockProperties.CODEC.optionalFieldOf("properties", (Object)BlockProperties.EMPTY).forGetter(BlockInput::getProperties)).apply((Applicative)instance, (id, tag, properties) -> BlockInput.create(id.orElse(null), (TagKey<Block>)((TagKey)tag.orElse(null)), properties)));
    public static final Codec<BlockInput> CODEC_STR = Codec.STRING.xmap(BlockInput::create, BlockInput::getTaggable);
    public static final MultiCodec<BlockInput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), (T toEncode) -> {
        if (toEncode.isAny()) {
            return TestedCodec.fail(() -> "Can be encoded as empty string");
        }
        if (toEncode.getProperties().equals(BlockProperties.EMPTY)) {
            return TestedCodec.fail(() -> "Can be encoded as simple id or tag");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockInput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final SlotDisplay.Type<BlockInput> TYPE = new SlotDisplay.Type(CODEC_COMP, STREAM_CODEC);
    @Nullable
    private final ResourceLocation id;
    @Nullable
    private final TagKey<Block> tag;
    @NotNull
    private final BlockProperties properties;
    private transient OnLoadSupplier<ImmutableList<ItemStack>> displayStacks;
    private boolean virtualRender = false;

    public static BlockInput create(String s) {
        if (s.startsWith("#")) {
            s = s.substring(1);
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)s));
            return BlockInput.ofTag((TagKey<Block>)tag);
        }
        if (s.isEmpty()) {
            return ANY;
        }
        return BlockInput.of(ResourceLocation.parse((String)s));
    }

    protected static BlockInput create(@Nullable ResourceLocation id, @Nullable TagKey<Block> tag, @NotNull BlockProperties properties) {
        BlockInput blockInput = new BlockInput(id, tag, properties);
        if (blockInput.isAny()) {
            return ANY;
        }
        return blockInput;
    }

    public static BlockInput ofTag(ResourceLocation id) {
        return BlockInput.ofTag((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id));
    }

    public static BlockInput ofTag(ResourceLocation id, BlockProperties properties) {
        return BlockInput.ofTag((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id), properties);
    }

    public static BlockInput ofTag(TagKey<Block> tag) {
        return BlockInput.ofTag(tag, BlockProperties.EMPTY);
    }

    public static BlockInput ofTag(TagKey<Block> tag, BlockProperties properties) {
        return new BlockInput(null, tag, properties);
    }

    public static BlockInput of(@NotNull ResourceLocation id) {
        return BlockInput.of(id, BlockProperties.EMPTY);
    }

    public static BlockInput of(@NotNull ResourceLocation id, BlockProperties properties) {
        return new BlockInput(id, null, properties);
    }

    public static BlockInput of(@NotNull Block block) {
        return BlockInput.of(Objects.requireNonNull(block.arch$registryName()));
    }

    public static BlockInput of(@NotNull BlockState state) {
        return new BlockInput(Objects.requireNonNull(state.getBlock().arch$registryName()), null, BlockProperties.extract(state));
    }

    protected BlockInput(@Nullable ResourceLocation id, @Nullable TagKey<Block> tag, @NotNull BlockProperties properties) {
        this.id = id;
        this.tag = tag;
        if (this.id != null && this.tag != null) {
            throw new IllegalArgumentException("id and tag cannot be set at the same time");
        }
        this.properties = properties;
        this.displayStacks = OnLoadSupplier.of(() -> {
            this.virtualRender = false;
            if (this.getId().isPresent()) {
                ItemStack displayStack = BuiltInRegistries.BLOCK.getOptional(this.getId().get()).map(block -> {
                    ItemStack stack = block.asItem().getDefaultInstance();
                    if (stack.isEmpty()) {
                        stack = Texts.rename(STACK_PLACEHOLDER.get(), (Component)Texts.translatable(block.getDescriptionId(), new Object[0]));
                        this.virtualRender = true;
                    }
                    stack.set(BlockProperties.TYPE, (Object)this.getProperties());
                    return stack;
                }).orElseGet(() -> {
                    DisplayableRecipe.LOGGER.error("Block with id '{}' not found, using placeholder", (Object)this.getId().get());
                    this.virtualRender = true;
                    return Texts.tooltip(STACK_PLACEHOLDER.get().copy(), Texts.literal(this.getTaggable(), new Style[0]));
                });
                return ImmutableList.of((Object)displayStack);
            }
            if (this.getTag().isPresent()) {
                LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
                for (Holder<Block> holder : TagUtil.forEntries(this.getTag().get())) {
                    Block block2 = (Block)holder.value();
                    ItemStack stack = block2.asItem().getDefaultInstance();
                    if (stack.isEmpty()) {
                        stack = Texts.rename(STACK_PLACEHOLDER.get(), (Component)Texts.translatable(block2.getDescriptionId(), new Object[0]));
                        this.virtualRender = true;
                    }
                    stack.set(BlockProperties.TYPE, (Object)this.getProperties());
                    stacks.add(stack);
                }
                if (stacks.isEmpty()) {
                    DisplayableRecipe.LOGGER.error("Block tag '{}' is empty, using placeholder", (Object)this.getTag().get().location());
                    this.virtualRender = true;
                    stacks.add(Texts.tooltip(STACK_UNKNOWN.copy(), Texts.literal(this.getTaggable(), new Style[0])));
                }
                return ImmutableList.copyOf(stacks);
            }
            if (this.getProperties().isEmpty()) {
                return ImmutableList.of((Object)STACK_ANY);
            }
            this.virtualRender = true;
            ItemStack stack = STACK_PLACEHOLDER.get();
            stack.set(BlockProperties.TYPE, (Object)this.getProperties());
            return ImmutableList.of((Object)stack);
        });
    }

    public Optional<ResourceLocation> getId() {
        return Optional.ofNullable(this.id);
    }

    public ResourceLocation getDisplayId() {
        return this.getTag().map(TagKey::location).orElse(((ItemStack)this.getDisplayStacks().getFirst()).getItem().arch$registryName());
    }

    public Optional<TagKey<Block>> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @NotNull
    protected BlockProperties getProperties() {
        return this.properties;
    }

    public BlockState getExampleState() {
        Iterable<Holder<Block>> candidates;
        BlockState state = this.getId().isPresent() ? ((Block)BuiltInRegistries.BLOCK.getValue(this.getId().get())).defaultBlockState() : (this.getTag().isPresent() ? ((candidates = TagUtil.forEntries(this.getTag().get())).iterator().hasNext() ? ((Block)candidates.iterator().next().value()).defaultBlockState() : Blocks.BEDROCK.defaultBlockState()) : ((Placeholder)((Object)CropariaBlocks.PLACEHOLDER.get())).defaultBlockState());
        return StateHolderAccess.apply(state, this.getProperties());
    }

    @NotNull
    public ImmutableList<ItemStack> getDisplayStacks() {
        return this.displayStacks.get();
    }

    public void mapStacks(Function<ImmutableList<ItemStack>, ImmutableList<ItemStack>> mapper) {
        this.displayStacks = this.displayStacks.map(mapper);
    }

    public String getTaggable() {
        Optional<String> id = this.getId().map(ResourceLocation::toString);
        Optional<String> tag = this.getTag().map(t -> "#" + String.valueOf(t.location()));
        return id.orElse(tag.orElse(""));
    }

    public boolean isVirtualRender() {
        this.displayStacks.get();
        return this.virtualRender;
    }

    public boolean isAny() {
        return this.getId().isEmpty() && this.getTag().isEmpty() && this.getProperties().isEmpty();
    }

    public boolean isUnknown() {
        ImmutableList<ItemStack> stacks = this.getDisplayStacks();
        if (stacks.size() != 1) {
            return false;
        }
        return Objects.equals(((ItemStack)stacks.getFirst()).getItem(), Items.BEDROCK) && this.isVirtualRender();
    }

    public boolean matches(@NotNull Block block) {
        if (this.getId().isPresent()) {
            return Objects.equals(block.arch$registryName(), this.getId().get());
        }
        if (this.getTag().isPresent()) {
            return TagUtil.isIn(this.getTag().get(), block);
        }
        return true;
    }

    public boolean matches(@NotNull BlockState state) {
        return this.matches(state.getBlock()) && this.getProperties().isSubsetOf(state);
    }

    @NotNull
    public <T> Stream<T> resolve(ContextMap contextMap, DisplayContentsFactory<T> factory) {
        if (factory instanceof DisplayContentsFactory.ForStacks) {
            DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
            return this.getDisplayStacks().stream().map(arg_0 -> ((DisplayContentsFactory.ForStacks)forStacks).forStack(arg_0));
        }
        return Stream.empty();
    }

    @NotNull
    public SlotDisplay.Type<? extends SlotDisplay> type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockInput)) {
            return false;
        }
        BlockInput that = (BlockInput)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.tag, that.tag) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.properties);
    }

    static {
        STACK_UNKNOWN.set(DataComponents.CUSTOM_NAME, (Object)Texts.translatable("tooltip.croparia.unknown", new Object[0]));
        STACK_AIR.set(DataComponents.CUSTOM_NAME, (Object)Texts.translatable("tooltip.croparia.air", new Object[0]));
        STACK_ANY.set(DataComponents.CUSTOM_NAME, (Object)Texts.translatable("tooltip.croparia.any", new Object[0]));
    }
}

