/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import org.jetbrains.annotations.NotNull;

public class ItemOutput
implements SlotDisplay {
    public static final Codec<ItemOutput> CODEC_STR = ResourceLocation.CODEC.xmap(id -> new ItemOutput((ResourceLocation)id, 1), ItemOutput::getId);
    public static final MapCodec<ItemOutput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ItemOutput::getId), (App)DataComponentPatch.CODEC.optionalFieldOf("components").forGetter(itemOutput -> Optional.of(itemOutput.getComponentsPatch())), (App)Codec.LONG.optionalFieldOf("amount").forGetter(result -> Optional.of(result.getAmount()))).apply((Applicative)instance, (id, components, amount) -> new ItemOutput((ResourceLocation)id, components.orElse(DataComponentPatch.EMPTY), amount.orElse(1L))));
    public static final MultiCodec<ItemOutput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toEncode -> {
        if (toEncode.getComponentsPatch().isEmpty() && toEncode.getAmount() == 1L) {
            return TestedCodec.fail(() -> "Can be encoded as string");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemOutput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final SlotDisplay.Type<ItemOutput> TYPE = new SlotDisplay.Type(CODEC_COMP, STREAM_CODEC);
    public static final ItemOutput EMPTY = new ItemOutput();
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final DataComponentPatch components;
    private final long amount;
    @NotNull
    private final transient ItemSpec itemSpec;
    @NotNull
    private final transient ItemStack displayStack;

    public static ItemOutput of(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return new ItemOutput(stack);
    }

    private ItemOutput() {
        this.id = BuiltInRegistries.ITEM.getKey((Object)Items.AIR);
        this.components = DataComponentPatch.EMPTY;
        this.amount = 0L;
        this.itemSpec = new ItemSpec((Item)BuiltInRegistries.ITEM.getValue(this.id), this.components);
        this.displayStack = this.toSpec().createStack(this.getAmount());
    }

    public ItemOutput(@NotNull ItemStack stack) {
        this(Objects.requireNonNull(stack.getItem().arch$registryName()), stack.getComponentsPatch(), stack.getCount());
    }

    public ItemOutput(@NotNull ResourceLocation id, int amount) {
        this(id, DataComponentPatch.EMPTY, amount);
    }

    public ItemOutput(@NotNull ResourceLocation id, @NotNull DataComponentPatch components, long amount) {
        this.id = id;
        this.components = components;
        this.amount = amount;
        if (this.amount <= 0L) {
            CropariaIf.LOGGER.warn("Creating ItemOutput with non-positive amount: {}", (Object)this.amount);
        }
        this.itemSpec = new ItemSpec((Item)BuiltInRegistries.ITEM.getValue(id), components);
        if (this.itemSpec.isEmpty()) {
            throw new IllegalArgumentException("Unknown or invalid item: " + String.valueOf(id));
        }
        this.displayStack = this.toSpec().createStack(this.getAmount());
    }

    @NotNull
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public DataComponentPatch getComponentsPatch() {
        return this.components;
    }

    public long getAmount() {
        return this.amount;
    }

    @NotNull
    public ItemSpec toSpec() {
        return this.itemSpec;
    }

    public ItemStack createStack() {
        return this.toSpec().createStack(this.getAmount());
    }

    @NotNull
    public <T> Stream<T> resolve(ContextMap contextMap, DisplayContentsFactory<T> factory) {
        if (factory instanceof DisplayContentsFactory.ForStacks) {
            DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
            return Stream.of(forStacks.forStack(this.getDisplayStack()));
        }
        return Stream.empty();
    }

    @NotNull
    public SlotDisplay.Type<? extends SlotDisplay> type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemOutput)) {
            return false;
        }
        ItemOutput that = (ItemOutput)o;
        return this.amount == that.amount && Objects.equals(this.id, that.id) && Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.components, this.amount);
    }
}

